/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionEvent;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.address.JccCalledPartyBCDNumber;

public class JccConnectionEventImpl
implements JccConnectionEvent,
Runnable {
    int id;
    private AbstractConnection connection;
    int cause;
    protected JccCalledPartyBCDNumber destAddress;

    public JccConnectionEventImpl(int id, JccConnection connection, int cause) {
        this.id = id;
        this.connection = (AbstractConnection)connection;
        this.cause = cause;
    }

    public JccCall getCall() {
        return this.connection.getCall();
    }

    public int getCause() {
        return this.cause;
    }

    public JccConnection getConnection() {
        return this.connection;
    }

    public int getID() {
        return this.id;
    }

    public Object getSource() {
        return this.connection;
    }

    public String toString() {
        switch (this.id) {
            case 115: {
                return "javax.csapi.cc.jcc.CONNECTION_ADDRESS_ANALYZE";
            }
            case 114: {
                return "javax.csapi.cc.jcc.CONNECTION_ADDRESS_COLLECT";
            }
            case 104: {
                return "javax.csapi.cc.jcc.CONNECTION_ALERTING";
            }
            case 113: {
                return "javax.csapi.cc.jcc.CONNECTION_AUTHORIZE_CALL_ATTEMPT";
            }
            case 116: {
                return "javax.csapi.cc.jcc.CONNECTION_CALL_DELIVERY";
            }
            case 105: {
                return "javax.csapi.cc.jcc.CONNECTION_CONNECTED";
            }
            case 106: {
                return "javax.csapi.cc.jcc.CONNECTION_CREATED";
            }
            case 107: {
                return "javax.csapi.cc.jcc.CONNECTION_DISCONNECTED";
            }
            case 108: {
                return "javax.csapi.cc.jcc.CONNECTION_FAILED";
            }
            case 123: {
                return "javax.csapi.cc.jcc.CONNECTION_MID_CALL";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.connection.cause = this.cause;
        switch (this.id) {
            case 106: {
                this.connection.state = 1;
                this.connection.onConnectionCreated();
                break;
            }
            case 113: {
                this.connection.state = 2;
                this.connection.onAuthorizeCallAttempt();
                break;
            }
            case 114: {
                this.connection.state = 3;
                this.connection.onAddressCollect();
                break;
            }
            case 115: {
                this.connection.state = 4;
                this.connection.onAddressAnalyze(this);
                break;
            }
            case 116: {
                this.connection.state = 5;
                this.connection.onCallDelivery();
                break;
            }
            case 104: {
                this.connection.state = 6;
                this.connection.onAlerting();
                break;
            }
            case 105: {
                this.connection.state = 7;
                this.connection.onConnected();
                break;
            }
            case 108: {
                this.connection.state = 9;
                this.connection.onFailed();
                break;
            }
            case 107: {
                this.connection.state = 0;
                this.connection.onDisconnected();
            }
        }
        this.connection.fireConnectionEvent(this);
        if (this.connection.getState() == 0) {
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.connection.close();
            }
        }
    }
}

