/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import java.util.Enumeration;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccEvent;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.ConnectionID;
import org.mobicents.jcc.inap.JccCallImpl;
import org.mobicents.jcc.inap.JccConnectionEventImpl;
import org.mobicents.jcc.inap.JccInapProviderImpl;
import org.mobicents.jcc.inap.OriginatingConnection;
import org.mobicents.jcc.inap.TerminatingConnection;
import org.mobicents.jcc.inap.address.JccCalledPartyBCDNumber;
import org.mobicents.jcc.inap.protocol.EventReportBCSM;
import org.mobicents.jcc.inap.protocol.InitialDP;
import org.mobicents.jcc.inap.protocol.Operation;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyBcdNumber;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.CallingPartyNumber;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.Invoke;
import org.mobicents.jcc.inap.protocol.tcap.TCBegin;
import org.mobicents.jcc.inap.protocol.tcap.TCContinue;
import org.mobicents.jcc.inap.protocol.tcap.TCMessage;
import org.mobicents.ss7.sccp.SccpAddress;

public class TCHandler
implements Runnable {
    private JccInapProviderImpl provider = null;
    private SccpAddress calledPartyAddress;
    private SccpAddress callingPartyAddress;
    private byte[] data;
    private TCMessage message;
    private static Logger logger = Logger.getLogger(TCHandler.class);

    public TCHandler(JccInapProviderImpl provider, SccpAddress calledPartyAddress, SccpAddress callingPartyAddress, TCMessage message) {
        this.provider = provider;
        this.calledPartyAddress = calledPartyAddress;
        this.callingPartyAddress = callingPartyAddress;
        this.message = message;
    }

    private boolean isOutgoingCall(InitialDP initialDP) {
        return initialDP.getCalledPartyBcdNumber() != null;
    }

    private boolean isOutAllowed(InitialDP initialDP) {
        return initialDP.getCallingPartyNumber().getAddress().endsWith("9023629581") || initialDP.getCallingPartyNumber().getAddress().endsWith("9023802866");
    }

    private boolean isIncAllowed(InitialDP initialDP) {
        return initialDP.getCalledPartyNumber() != null && initialDP.getCalledPartyNumber().getAddress().endsWith("9023629581") || initialDP.getCalledPartyNumber() != null && initialDP.getCalledPartyNumber().getAddress().endsWith("9023629581");
    }

    public void run() {
        long txID = this.message.getTxID();
        switch (this.message.getType()) {
            case 98: {
                TCBegin begin = (TCBegin)this.message;
                Invoke invoke = (Invoke)begin.getComponents().get(0);
                InitialDP initialDP = (InitialDP)invoke.getOperation();
                if (initialDP.getCallingPartyNumber() == null) {
                    logger.warn((Object)("txID = " + txID + ", [InitialDP] CallingPartyNumber missing"));
                    return;
                }
                CallingPartyNumber callingPartyNumber = initialDP.getCallingPartyNumber();
                JccAddress callingNumber = this.provider.createAddress(callingPartyNumber);
                JccCallImpl call = this.provider.calls.containsKey((Object)callingNumber.getName()) ? this.provider.getCall(callingNumber) : this.provider.createCall(callingNumber);
                ConnectionID connectionID = new ConnectionID(txID, this.calledPartyAddress, this.callingPartyAddress);
                JccAddress calledNumber = null;
                if (initialDP.getCalledPartyBcdNumber() != null) {
                    OriginatingConnection connection = new OriginatingConnection(connectionID, call, callingNumber);
                    JccConnectionEventImpl evt = new JccConnectionEventImpl(106, connection, 106);
                    connection.queueEvent((JccEvent)evt);
                    CalledPartyBcdNumber bcdNumber = initialDP.getCalledPartyBcdNumber();
                    calledNumber = this.provider.createAddress(bcdNumber);
                    evt = new JccConnectionEventImpl(115, connection, 106);
                    evt.destAddress = (JccCalledPartyBCDNumber)calledNumber;
                    connection.queueEvent((JccEvent)evt);
                    break;
                }
                if (initialDP.getCalledPartyNumber() != null) {
                    CalledPartyNumber calledPartyNumber = initialDP.getCalledPartyNumber();
                    calledNumber = this.provider.createAddress(calledPartyNumber);
                    TerminatingConnection connection = new TerminatingConnection(connectionID, call, calledNumber, callingNumber);
                    JccConnectionEventImpl evt = new JccConnectionEventImpl(106, connection, 106);
                    connection.queueEvent((JccEvent)evt);
                    evt = new JccConnectionEventImpl(113, connection, 106);
                    connection.queueEvent((JccEvent)evt);
                    break;
                }
                logger.warn((Object)("txID = " + txID + ", [InitialDP] either " + "CalledPartyNumber or CalledPartyBCDNumber missing"));
                break;
            }
            case 101: {
                AbstractConnection connection = this.provider.getConnection(txID);
                if (connection == null) {
                    logger.warn((Object)("Unknown connection " + txID));
                    return;
                }
                TCContinue continueInd = (TCContinue)this.message;
                Components components = continueInd.getComponents();
                if (components == null) {
                    logger.warn((Object)"One or more components are missing");
                    return;
                }
                Enumeration elements = components.elements();
                block14: while (elements.hasMoreElements()) {
                    Invoke invoke = (Invoke)elements.nextElement();
                    Operation operation = invoke.getOperation();
                    switch (operation.getCode()) {
                        case 24: {
                            EventReportBCSM bcsmEvent = (EventReportBCSM)operation;
                            switch (bcsmEvent.getEventType()) {
                                case 7: 
                                case 15: {
                                    JccConnectionEventImpl evt = new JccConnectionEventImpl(105, connection, 100);
                                    connection.queueEvent((JccEvent)evt);
                                    break;
                                }
                                case 9: 
                                case 17: {
                                    JccConnectionEventImpl evt = new JccConnectionEventImpl(107, connection, 100);
                                    connection.queueEvent((JccEvent)evt);
                                    break;
                                }
                                case 5: 
                                case 13: {
                                    JccConnectionEventImpl evt = new JccConnectionEventImpl(107, connection, 113);
                                    connection.queueEvent((JccEvent)evt);
                                    break;
                                }
                                case 6: 
                                case 14: {
                                    JccConnectionEventImpl evt = new JccConnectionEventImpl(107, connection, 114);
                                    connection.queueEvent((JccEvent)evt);
                                }
                            }
                            continue block14;
                        }
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Ignoring");
                }
                break;
            }
            case 103: {
                AbstractConnection connection = this.provider.getConnection(txID);
                if (connection == null) {
                    logger.warn((Object)("Unknown connection " + txID));
                    return;
                }
                JccConnectionEventImpl evt = new JccConnectionEventImpl(108, connection, 102);
                connection.queueEvent((JccEvent)evt);
            }
        }
    }
}

