/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import java.io.IOException;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidPartyException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccEvent;
import javax.csapi.cc.jcc.MethodNotSupportedException;
import javax.csapi.cc.jcc.MidCallData;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.AbstractConnection;
import org.mobicents.jcc.inap.ConnectionID;
import org.mobicents.jcc.inap.JccCallImpl;
import org.mobicents.jcc.inap.JccConnectionEventImpl;
import org.mobicents.jcc.inap.address.JccCalledPartyNumber;
import org.mobicents.jcc.inap.protocol.ApplyCharging;
import org.mobicents.jcc.inap.protocol.CallInformationRequest;
import org.mobicents.jcc.inap.protocol.Connect;
import org.mobicents.jcc.inap.protocol.Continue;
import org.mobicents.jcc.inap.protocol.RequestBCSMState;
import org.mobicents.jcc.inap.protocol.parms.BCSMEvent;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.LegID;
import org.mobicents.jcc.inap.protocol.parms.RequestedInformationTypeList;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.DialoguePortion;
import org.mobicents.jcc.inap.protocol.tcap.Invoke;
import org.mobicents.jcc.inap.protocol.tcap.TCContinue;
import org.mobicents.ss7.sccp.SccpAddress;

public class TerminatingConnection
extends AbstractConnection {
    private JccCalledPartyNumber destinationAddress;
    private String lastAddress;
    private String originalAddress;
    private String redirectedAddress;
    private JccAddress originatingAddress;

    public TerminatingConnection(ConnectionID connectionID, JccCallImpl call, JccAddress address, JccAddress originatingAddress) {
        super(connectionID, call, address);
        this.logger = Logger.getLogger(TerminatingConnection.class);
        this.originatingAddress = originatingAddress;
        this.destinationAddress = (JccCalledPartyNumber)address;
    }

    public void onAuthorizeCallAttempt() {
        this.logger.info((Object)(this + "AUTHORIZE_CALL_ATTEMPT, " + TerminatingConnection.getCauseName(this.cause)));
        this.timer.reset(5);
        JccConnectionEventImpl evt = new JccConnectionEventImpl(116, this, this.cause);
        this.queueEvent((JccEvent)evt);
    }

    public void onAddressCollect() {
    }

    public void onAddressAnalyze(JccConnectionEventImpl evt) {
    }

    public void onCallDelivery() {
        this.logger.info((Object)(this + "CALL_DELIVERY, " + TerminatingConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onCallDelivery(): reset timeout timer"));
        }
        this.timer.reset(65);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onCallDelivery(): sending signaling message to MSC"));
        }
        CalledPartyNumber routeNumber = this.destinationAddress.getRouteAddress();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "connecting to " + routeNumber));
        }
        Connect connect = new Connect(routeNumber);
        RequestBCSMState bcsm = new RequestBCSMState();
        bcsm.add(new BCSMEvent(15));
        bcsm.add(new BCSMEvent(14));
        bcsm.add(new BCSMEvent(13));
        bcsm.add(new BCSMEvent(18));
        ApplyCharging applyCharging = new ApplyCharging(128, 1);
        RequestedInformationTypeList list = new RequestedInformationTypeList();
        list.add(1);
        list.add(2);
        list.add(30);
        LegID legID = new LegID(128, 2);
        CallInformationRequest cir = new CallInformationRequest(list, legID);
        Continue cont = new Continue();
        Components components = new Components();
        components.add(new Invoke(1, applyCharging));
        components.add(new Invoke(2, bcsm));
        components.add(new Invoke(3, cir));
        components.add(new Invoke(4, connect));
        TCContinue message = new TCContinue(this.connectionID.getId());
        message.setDialogue(new DialoguePortion());
        message.setComponents(components);
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
            JccConnectionEventImpl evt = new JccConnectionEventImpl(104, this, 100);
            this.queueEvent((JccEvent)evt);
        }
        catch (IOException e) {
            this.logger.error((Object)"I/O Error", (Throwable)e);
            JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this, 116);
            this.queueEvent((JccEvent)evt);
        }
    }

    public void onAlerting() {
        this.logger.info((Object)(this + "ALERTING"));
        this.timer.reset(65);
    }

    public void onConnected() {
        this.logger.info((Object)(this + "CONNECTED, " + TerminatingConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onConnected(): reset timeout timer"));
        }
        this.timer.reset(1805);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onConnected(): sending signaling message to MSC"));
        }
        RequestBCSMState bcsm = new RequestBCSMState();
        bcsm.add(new BCSMEvent(17, new LegID(128, 1)));
        bcsm.add(new BCSMEvent(17, new LegID(128, 2)));
        Continue cont = new Continue();
        Components components = new Components();
        components.add(new Invoke(1, bcsm));
        components.add(new Invoke(2, cont));
        TCContinue message = new TCContinue(this.connectionID.getId());
        message.setComponents(components);
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
        }
        catch (IOException e) {
            this.logger.error((Object)"I/O Error", (Throwable)e);
            JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this, 116);
            this.queueEvent((JccEvent)evt);
        }
    }

    public void selectRoute(String digits) throws MethodNotSupportedException, InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, InvalidPartyException {
        this.destinationAddress.setName(digits);
        if (this.isBlocked()) {
            this.resume();
        }
    }

    public void answer() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException, MethodNotSupportedException {
    }

    public void attachMedia() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException {
    }

    public void detachMedia() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException {
    }

    public String getLastAddress() {
        return this.address.getName();
    }

    public String getOriginalAddress() {
        return this.address.getName();
    }

    public String getDestinationAddress() {
        return null;
    }

    public JccAddress getOriginatingAddress() {
        return this.originatingAddress;
    }

    public String getRedirectedAddress() {
        return this.redirectedAddress;
    }

    public void routeConnection(boolean b) throws InvalidStateException, ResourceUnavailableException, PrivilegeViolationException, MethodNotSupportedException, InvalidPartyException, InvalidArgumentException {
    }

    public MidCallData getMidCallData() throws InvalidStateException, ResourceUnavailableException, MethodNotSupportedException {
        return null;
    }
}

