/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.gt;

import java.io.Serializable;
import org.mobicents.jcc.inap.gt.Operation;

public class Pattern
implements Serializable,
Comparable {
    private String pattern;
    private String template;

    public Pattern(String pattern) {
        this.pattern = pattern;
        this.template = this.toRegExpression(pattern.split("/")[0]);
    }

    private String toRegExpression(String pattern) {
        pattern = pattern.replaceAll("x", "\\\\d");
        pattern = pattern.replaceAll("\\*", "\\\\w*");
        return pattern;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getResult(String number) {
        String[] parts = this.pattern.split("/");
        if (parts.length == 1) {
            return number;
        }
        Object expression = number;
        for (int i = 1; i < parts.length; ++i) {
            String operationExpression = parts[i];
            String[] oparts = operationExpression.split(" ");
            String name = oparts[0];
            String[] args = oparts[1].split(",");
            Object[] argv = new Object[args.length + 1];
            argv[0] = expression;
            for (int j = 0; j < args.length; ++j) {
                argv[j + 1] = args[j];
            }
            expression = Operation.getInstance(name, argv);
        }
        return ((Operation)expression).execute();
    }

    public boolean matches(String pattern) {
        return pattern.matches(this.template);
    }

    public int compareTo(Object other) {
        return this.template.compareTo(((Pattern)other).getTemplate());
    }
}

