/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.Operation;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.CallingPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.GenericNumber;

public class Connect
extends Operation {
    private CalledPartyNumber calledPartyNumber;
    private GenericNumber gn;
    private CallingPartyNumber callingPartyNumber;

    public Connect(CalledPartyNumber calledPartyNumber) {
        this.calledPartyNumber = calledPartyNumber;
    }

    public void setGenericNumber(GenericNumber gn) {
        this.gn = gn;
    }

    public void setCallingPartyNumber(CallingPartyNumber callingPartyNumber) {
        this.callingPartyNumber = callingPartyNumber;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            byte[] gnb;
            byte[] cpn = this.calledPartyNumber.toByteArray();
            bout.write(4);
            bout.write(cpn.length);
            bout.write(cpn);
            byte[] buffer = bout.toByteArray();
            bout = new ByteArrayOutputStream();
            bout.write(-96);
            bout.write(buffer.length);
            bout.write(buffer);
            if (this.gn != null) {
                gnb = this.encGn();
                bout.write(174);
                bout.write(gnb.length);
                bout.write(gnb);
            }
            if (this.callingPartyNumber != null) {
                gnb = this.callingPartyNumber.toByteArray();
                bout.write(155);
                bout.write(gnb.length);
                bout.write(gnb);
            }
            buffer = bout.toByteArray();
            bout = new ByteArrayOutputStream();
            bout.write(48);
            bout.write(buffer.length);
            bout.write(buffer);
            buffer = bout.toByteArray();
            bout = new ByteArrayOutputStream();
            bout.write(2);
            bout.write(1);
            bout.write(20);
            bout.write(buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("CONNECT[");
        buff.append(this.calledPartyNumber.toString());
        if (this.gn != null) {
            buff.append("," + this.gn.toString());
        }
        buff.append("]");
        return buff.toString();
    }

    private byte[] encGn() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] hx = this.gn.toByteArray();
        bout.write(4);
        bout.write(hx.length);
        bout.write(hx);
        return bout.toByteArray();
    }
}

