/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.Operation;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyBcdNumber;
import org.mobicents.jcc.inap.protocol.parms.CalledPartyNumber;
import org.mobicents.jcc.inap.protocol.parms.CallingPartyNumber;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class InitialDP
extends Operation {
    private int serviceKey;
    private CalledPartyNumber calledPartyNumber;
    private CallingPartyNumber callingPartyNumber;
    private CalledPartyBcdNumber calledPartyBcdNumber;

    public InitialDP() {
    }

    public InitialDP(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        while (in.available() > 0) {
            int param = Util.readTag(in);
            int length = Util.readLen(in);
            byte[] buff = new byte[length];
            in.read(buff);
            switch (param) {
                case 0: {
                    this.serviceKey = buff[0];
                    break;
                }
                case 2: {
                    this.calledPartyNumber = new CalledPartyNumber(buff);
                    break;
                }
                case 3: {
                    this.callingPartyNumber = new CallingPartyNumber(buff);
                    break;
                }
                case 56: {
                    this.calledPartyBcdNumber = new CalledPartyBcdNumber(buff);
                }
            }
        }
    }

    public int getServiceKey() {
        return this.serviceKey;
    }

    public CalledPartyBcdNumber getCalledPartyBcdNumber() {
        return this.calledPartyBcdNumber;
    }

    public CalledPartyNumber getCalledPartyNumber() {
        return this.calledPartyNumber;
    }

    public CallingPartyNumber getCallingPartyNumber() {
        return this.callingPartyNumber;
    }

    public byte[] toByteArray() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InitialDP { CallingPartyNumber=" + this.callingPartyNumber);
        if (this.calledPartyNumber != null) {
            buffer.append(",CalledPartyNumber=" + this.calledPartyNumber);
        }
        if (this.calledPartyBcdNumber != null) {
            buffer.append(",CalledPartyBcdNumber=" + this.calledPartyBcdNumber);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

