/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;

public class CalledPartyBcdNumber
implements Serializable {
    private String address;
    private int ext;
    private int ni;
    private int np;

    public CalledPartyBcdNumber(int ext, int ni, int np, String address) {
        this.ext = ext;
        this.ni = ni;
        this.np = np;
        this.address = address;
    }

    public CalledPartyBcdNumber(String address) {
        this.address = address;
        this.ni = 3;
    }

    public CalledPartyBcdNumber(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        int length = bin.length;
        int b = in.read() & 0xFF;
        this.ext = (b & 0x7F) >> 7;
        this.ni = (b & 0x70) >> 4;
        this.np = b & 0xF;
        --length;
        this.address = "";
        while (length - 1 > 0) {
            b = in.read() & 0xFF;
            int d1 = b & 0xF;
            int d2 = (b & 0xF0) >> 4;
            this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
            --length;
        }
        b = in.read() & 0xFF;
        this.address = this.address + Integer.toHexString(b & 0xF);
        int c = (b & 0xF0) >> 4;
        if (c != 15) {
            this.address = this.address + Integer.toHexString(c);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String digits) {
        this.address = digits;
    }

    public int getNi() {
        return this.ni;
    }

    public int getNp() {
        return this.np;
    }

    public int getExt() {
        return this.ext;
    }

    public String toString() {
        return this.ni + ":" + this.address;
    }
}

