/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.parms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class CalledPartyNumber
implements Serializable {
    public static final int SPARE = 0;
    public static final int SUBSCRIBER = 1;
    public static final int UNKNOWN = 2;
    public static final int NATIONAL = 3;
    public static final int INTERNATIONAL = 4;
    private String address;
    private int nai = 4;
    private int inni = 0;
    private int npi = 1;

    public CalledPartyNumber(int nai, int inni, int npi, String address) {
        this.nai = nai;
        this.inni = inni;
        this.npi = npi;
        this.address = address;
    }

    public CalledPartyNumber(String address) {
        this.address = address;
        this.nai = 3;
    }

    public CalledPartyNumber(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        int length = bin.length;
        int b = in.read() & 0xFF;
        int oddFlag = (b & 0x80) >> 7;
        this.nai = b & 0x7F;
        b = in.read() & 0xFF;
        this.inni = (b & 0x80) >> 7;
        this.npi = (b & 0x70) >> 4;
        length -= 2;
        this.address = "";
        while (length - 1 > 0) {
            b = in.read() & 0xFF;
            int d1 = b & 0xF;
            int d2 = (b & 0xF0) >> 4;
            this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
            --length;
        }
        b = in.read() & 0xFF;
        this.address = this.address + Integer.toHexString(b & 0xF);
        if (oddFlag != 1) {
            this.address = this.address + Integer.toHexString((b & 0xF0) >> 4);
        }
    }

    public int getNai() {
        return this.nai;
    }

    public int getInni() {
        return this.inni;
    }

    public int getNpi() {
        return this.npi;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean isOdd = this.address.length() % 2 != 0;
        int b = this.nai;
        if (isOdd) {
            b |= 0x80;
        }
        out.write(b);
        int c = this.npi << 4;
        out.write(c |= this.inni << 7);
        int count = !isOdd ? this.address.length() : this.address.length() - 1;
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.address.substring(i, i + 1);
            String ds2 = this.address.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            out.write(b);
        }
        if (isOdd) {
            String ds1 = this.address.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            out.write(b);
        }
        return out.toByteArray();
    }

    public String toString() {
        return this.nai + ":" + this.address;
    }
}

