/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.mobicents.jcc.inap.protocol.tcap.Component;
import org.mobicents.jcc.inap.protocol.tcap.Invoke;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class Components
extends Vector {
    public Components() {
    }

    public Components(byte[] bin) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bin);
        block3: while (in.available() > 0) {
            int code = in.read() & 0xFF;
            int len = Util.readLen(in);
            if (code == 0) {
                return;
            }
            if (len <= 0) {
                throw new IOException("Packet corrupted");
            }
            byte[] buffer = new byte[len];
            in.read(buffer);
            switch (code) {
                case 161: {
                    Invoke invoke = new Invoke(buffer);
                    this.add(invoke);
                    continue block3;
                }
            }
            System.out.println("Unknown tag: " + code);
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Enumeration list = this.elements();
        while (list.hasMoreElements()) {
            Component component = (Component)list.nextElement();
            try {
                bout.write(component.toByteArray());
            }
            catch (IOException e) {}
        }
        byte[] buff = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        bout.write(108);
        try {
            Util.encodeLength(buff.length, bout);
            bout.write(buff);
        }
        catch (IOException e) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            buffer.append(this.get(i));
        }
        buffer.append("}");
        return buffer.toString();
    }
}

