/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.DialoguePortion;
import org.mobicents.jcc.inap.protocol.tcap.TCMessage;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class TCContinue
extends TCMessage {
    public TCContinue(long txID) {
        super(txID);
    }

    public TCContinue(byte[] bin) throws IOException {
        boolean isDialoguePresent;
        this.type = 101;
        ByteArrayInputStream data = new ByteArrayInputStream(bin);
        int tag = data.read();
        int length = data.read();
        if (tag != 72) {
            throw new IOException("Originated TID should be present");
        }
        for (int i = 0; i < length; ++i) {
            this.txID = this.txID << 8 | (long)data.read();
        }
        tag = data.read();
        length = data.read();
        if (tag != 73) {
            throw new IOException("Destination TID should be present");
        }
        data.skip(length);
        tag = data.read() & 0xFF;
        length = Util.readLen(data);
        byte[] buff = new byte[length];
        data.read(buff);
        boolean bl = isDialoguePresent = tag == 107;
        if (isDialoguePresent) {
            this.dialogue = new DialoguePortion();
        }
        if (isDialoguePresent && data.available() > 0) {
            tag = data.read() & 0xFF;
            length = Util.readLen(data);
            buff = new byte[length];
            data.read(buff);
        }
        if (tag != 108) {
            throw new IOException("Component portion expected");
        }
        this.components = new Components(buff);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Util.encodeTransactioID(72, this.txID, bout);
            Util.encodeTransactioID(73, this.txID, bout);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.dialogue != null) {
            try {
                bout.write(this.dialogue.toByteArray());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.components != null) {
            try {
                bout.write(this.components.toByteArray());
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        byte[] buff = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        bout.write(101);
        try {
            Util.encodeLength(buff.length, bout);
            bout.write(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String toString() {
        return "CONTINUE (tx=" + this.getTxID() + "," + this.components + ")";
    }
}

