/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap.protocol.tcap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mobicents.jcc.inap.protocol.tcap.TCMessage;
import org.mobicents.jcc.inap.protocol.tcap.Util;

public class TCEnd
extends TCMessage {
    public TCEnd(long txID) {
        super(txID);
    }

    public TCEnd(byte[] bin) throws IOException {
        this.type = 100;
        ByteArrayInputStream data = new ByteArrayInputStream(bin);
        int tag = data.read();
        int length = data.read();
        if (tag != 73) {
            throw new IOException("Originated TID should be present");
        }
        for (int i = 0; i < length; ++i) {
            this.txID = this.txID << 8 | (long)data.read();
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            Util.encodeTransactioID(73, this.txID, bout);
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] buff = bout.toByteArray();
        bout = new ByteArrayOutputStream();
        bout.write(100);
        try {
            Util.encodeLength(buff.length, bout);
            bout.write(buff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String toString() {
        return "END (tx=" + this.getTxID() + ")";
    }
}

