/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.ss7.sccp.SccpListener;
import org.mobicents.ss7.sccp.SccpProvider;
import org.mobicents.ss7.sccp.UnitData;

public class Handler
implements Runnable {
    private SccpProvider provider = null;
    private byte[] packet;
    private Logger logger = Logger.getLogger(Handler.class);

    public Handler(SccpProvider provider, byte[] packet) {
        this.provider = provider;
        this.packet = packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ByteArrayInputStream bin = new ByteArrayInputStream(this.packet);
        DataInputStream in = new DataInputStream(bin);
        try {
            int o = in.readUnsignedByte();
            int ssf = o & 0xF0;
            int si = o & 0xF;
            int b1 = in.readUnsignedByte();
            int b2 = in.readUnsignedByte();
            int b3 = in.readUnsignedByte();
            int b4 = in.readUnsignedByte();
            int dpc = (b2 & 0x3F) << 8 | b1;
            int opc = (b4 & 0xF) << 10 | b3 << 2 | b1 & 0xC0;
            int sls = b4 & 0xF0;
            int mt = in.readUnsignedByte();
            switch (mt) {
                case 9: {
                    UnitData unitData = new UnitData();
                    unitData.decode(in);
                    Handler handler = this;
                    synchronized (handler) {
                        SccpListener listener = this.provider.getListener();
                        if (listener != null) {
                            listener.onMessage(unitData.getCalledParty(), unitData.getCallingParty(), unitData.getData());
                        }
                        break;
                    }
                }
                default: {
                    this.logger.warn((Object)("Unsupported message type: " + mt));
                }
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

