/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramSocket;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.mobicents.gct.InterProcessCommunicator;
import org.mobicents.ss7.sccp.Handler;
import org.mobicents.ss7.sccp.ProtocolClass;
import org.mobicents.ss7.sccp.SccpAddress;
import org.mobicents.ss7.sccp.SccpListener;
import org.mobicents.ss7.sccp.SccpProvider;
import org.mobicents.ss7.sccp.UnitData;
import org.mobicents.util.Utils;

public class SccpIntelHDCProviderImpl
implements Runnable,
SccpProvider {
    private Properties props;
    private InterProcessCommunicator ipc;
    private DatagramSocket socket;
    private SccpListener listener;
    private int src = 0;
    private int dst = 0;
    private int opc;
    private int dpc;
    private int sls;
    private int ssf;
    private int si;
    private boolean stopped = false;
    private PooledExecutor threadPool = new PooledExecutor(10);
    private Logger logger = Logger.getLogger(SccpIntelHDCProviderImpl.class);

    public SccpIntelHDCProviderImpl(Properties props) {
        this.props = props;
        this.src = Integer.parseInt(props.getProperty("module.src"));
        this.dst = Integer.parseInt(props.getProperty("module.dest"));
        this.opc = Integer.parseInt(props.getProperty("sccp.opc"));
        this.dpc = Integer.parseInt(props.getProperty("sccp.dpc"));
        this.sls = Integer.parseInt(props.getProperty("sccp.sls"));
        this.ssf = Integer.parseInt(props.getProperty("sccp.ssf"));
        this.si = Integer.parseInt(props.getProperty("sccp.si"));
        this.ipc = new InterProcessCommunicator(this.src, this.dst);
        this.logger.info((Object)"Started IPC");
        new Thread(this).start();
        this.logger.info((Object)"Started main loop");
    }

    public void addSccpListener(SccpListener listener) {
        this.listener = listener;
    }

    public SccpListener getListener() {
        return this.listener;
    }

    public synchronized void send(SccpAddress calledParty, SccpAddress callingParty, byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte b = (byte)(this.ssf << 4 | this.si);
        out.write(b);
        b = (byte)this.dpc;
        out.write(b);
        b = (byte)(this.dpc >> 8 & 0x3F | (this.opc & 3) << 6);
        out.write(b);
        b = (byte)(this.opc >> 2);
        out.write(b);
        b = (byte)(this.opc >> 10 & 0xF | this.sls << 4);
        out.write(b);
        UnitData unitData = new UnitData(new ProtocolClass(0, 0), calledParty, callingParty, data);
        unitData.encode(out);
        byte[] buf = out.toByteArray();
        this.ipc.send(buf);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)Utils.hexDump("Sent message\n", buf));
        }
    }

    public void run() {
        while (!this.stopped) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Waiting for packet delivery");
                }
                byte[] packet = this.ipc.receive();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)Utils.hexDump("Packet received\n", packet));
                }
                try {
                    this.threadPool.execute((Runnable)new Handler(this, packet));
                }
                catch (InterruptedException ie) {
                    this.logger.error((Object)"Thread pool interrupted", (Throwable)ie);
                    this.stopped = true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"I/O error occured while sending data to MTP3 driver", (Throwable)e);
            }
        }
        this.logger.info((Object)"Close main loop");
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
        this.stopped = true;
    }
}

