/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.sccp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.mobicents.ss7.sccp.Handler;
import org.mobicents.ss7.sccp.ProtocolClass;
import org.mobicents.ss7.sccp.SccpAddress;
import org.mobicents.ss7.sccp.SccpListener;
import org.mobicents.ss7.sccp.SccpProvider;
import org.mobicents.ss7.sccp.UnitData;
import org.mobicents.util.Utils;

public class SccpM3UAProviderImpl
implements Runnable,
SccpProvider {
    private SccpListener listener;
    private DatagramSocket socket;
    private Properties props;
    private String remoteAddress;
    private String localAddress;
    private int localPort;
    private int remotePort;
    private int opc;
    private int dpc;
    private int sls;
    private int ssf;
    private int si;
    private PooledExecutor threadPool = new PooledExecutor(10);
    private boolean stopped = false;
    private Logger logger = Logger.getLogger(SccpM3UAProviderImpl.class);

    public SccpM3UAProviderImpl(Properties props) throws Exception {
        this.props = props;
        this.remoteAddress = props.getProperty("remote.address");
        this.localAddress = props.getProperty("local.address");
        this.localPort = Integer.parseInt(props.getProperty("local.port"));
        this.remotePort = Integer.parseInt(props.getProperty("remote.port"));
        this.opc = Integer.parseInt(props.getProperty("sccp.opc"));
        this.dpc = Integer.parseInt(props.getProperty("sccp.dpc"));
        this.sls = Integer.parseInt(props.getProperty("sccp.sls"));
        this.ssf = Integer.parseInt(props.getProperty("sccp.ssf"));
        this.si = Integer.parseInt(props.getProperty("sccp.si"));
        this.socket = new DatagramSocket(this.localPort, InetAddress.getByName(this.localAddress));
        new Thread(this).start();
        this.logger.info((Object)"Running main thread");
    }

    public void run() {
        while (!this.stopped) {
            try {
                byte[] buffer = new byte[8446];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.socket.receive(packet);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Utils.hexDump("Packet received\n", packet));
                }
                byte[] data = new byte[packet.getLength()];
                System.arraycopy(packet.getData(), 0, data, 0, data.length);
                try {
                    this.logger.debug((Object)("--->" + Utils.hexDump(data)));
                    this.threadPool.execute((Runnable)new Handler(this, data));
                }
                catch (InterruptedException ie) {
                    this.logger.error((Object)"Thread pool interrupted", (Throwable)ie);
                    this.stopped = true;
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"I/O error occured while sending data to MTP3 driver", (Throwable)e);
            }
        }
    }

    public void addSccpListener(SccpListener listener) {
        this.listener = listener;
    }

    public SccpListener getListener() {
        return this.listener;
    }

    public void send(SccpAddress calledParty, SccpAddress callingParty, byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte b = (byte)(this.ssf << 4 | this.si);
        out.write(b);
        b = (byte)this.dpc;
        out.write(b);
        b = (byte)(this.dpc >> 8 & 0x3F | (this.opc & 3) << 6);
        out.write(b);
        b = (byte)(this.opc >> 2);
        out.write(b);
        b = (byte)(this.opc >> 10 & 0xF | this.sls << 4);
        out.write(b);
        UnitData unitData = new UnitData(new ProtocolClass(0, 0), calledParty, callingParty, data);
        unitData.encode(out);
        byte[] buff = out.toByteArray();
        DatagramPacket packet = new DatagramPacket(buff, buff.length, InetAddress.getByName(this.remoteAddress), this.remotePort);
        this.logger.debug((Object)Utils.hexDump(buff));
        this.socket.send(packet);
    }

    public void shutdown() {
        this.stopped = true;
        this.threadPool.shutdownNow();
        try {
            this.socket.disconnect();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

