/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip.wrappers;

import java.text.ParseException;
import java.util.TimerTask;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.SleeEndpoint;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.SipFactoryProvider;
import org.mobicents.slee.resource.sip.SipToSLEEUtility;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.ServerTransactionWrapper;

public class CancelWaitTimerTask
extends TimerTask {
    private ServerTransactionWrapper inviteTX;
    private ServerTransactionWrapper cancelTX;
    private static ComponentKey key = new ComponentKey("javax.sip.message.Request.CANCEL", "javax.sip", "1.1");
    private Logger log = null;
    private SipFactoryProvider sipFactoryProvider;
    private SleeEndpoint sleeEndpoint = null;
    private EventLookupFacility eventLookup = null;
    private RequestEventWrapper cancel = null;
    private boolean run = false;

    public CancelWaitTimerTask(RequestEventWrapper cancel, ServerTransactionWrapper inviteTransaction, SipFactoryProvider provider, SleeEndpoint endpoint, EventLookupFacility eventL, Logger logger) {
        this.inviteTX = inviteTransaction;
        this.cancelTX = (ServerTransactionWrapper)cancel.getServerTransaction();
        this.log = logger;
        this.sipFactoryProvider = provider;
        this.cancel = cancel;
        this.eventLookup = eventL;
        this.sleeEndpoint = endpoint;
    }

    public synchronized boolean hasRun() {
        return this.run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int eventID;
        CancelWaitTimerTask cancelWaitTimerTask = this;
        synchronized (cancelWaitTimerTask) {
            this.run = true;
        }
        int txState = this.inviteTX.getState().getValue();
        if (txState == 5 || txState == 3 || txState == 4) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("================================================== \nFINAL RESPONSE HAS BEEN SENT FOR TX, DROPPING CANCEL(CANCEL TIMER TASK): \n" + this.inviteTX + "\n=================================================="));
            }
            return;
        }
        DialogWrapper dialog = (DialogWrapper)this.inviteTX.getDialog();
        if (dialog != null) {
            dialog.cancel();
            try {
                Response requestTerminatedResponse = this.sipFactoryProvider.getMessageFactory().createResponse(487, this.inviteTX.getRequest());
                this.inviteTX.sendResponse(requestTerminatedResponse);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
            }
        }
        SipActivityHandle SAH = this.inviteTX.getActivityHandle();
        Request request = this.cancelTX.getRequest();
        FromHeader fromHeader = (FromHeader)request.getHeader("From");
        ToHeader toHeader = (ToHeader)request.getHeader("To");
        Address address = new Address(AddressPlan.SIP, toHeader.getAddress().toString());
        SipToSLEEUtility.displayMessage(this.getClass().getName(), "looking up event", key);
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
        }
        catch (FacilityException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup\t\t  event!", e2);
        }
        catch (UnrecognizedEventException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup  event!", e2);
        }
        if (eventID == -1) {
            SipToSLEEUtility.displayMessage(this.getClass().getName(), "Event is not a a registared event type:", key);
            return;
        }
        SipToSLEEUtility.displayDeliveryMessage(this.getClass().getName(), eventID, key, SAH);
        RequestEventWrapper eventObj = this.cancel;
        try {
            this.sleeEndpoint.fireEvent((ActivityHandle)SAH, (Object)eventObj, eventID, address);
        }
        catch (IllegalStateException e) {
            this.log.error((Object)"Unexpected exception ", (Throwable)e);
            e.printStackTrace();
        }
        catch (ActivityIsEndingException e) {
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
    }
}

