/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip.wrappers;

import java.util.Timer;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.SipResourceAdaptor;
import org.mobicents.slee.resource.sip.wrappers.CancelWaitTimerTask;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.RequestEventWrapper;
import org.mobicents.slee.resource.sip.wrappers.SecretWrapperInterface;

public class ServerTransactionWrapper
implements ServerTransaction,
SecretWrapperInterface {
    private static Logger logger = Logger.getLogger(ServerTransactionWrapper.class);
    private ServerTransaction realTransaction = null;
    private Object applicationData = null;
    private SleeContainer serviceContainer = null;
    private RequestEventWrapper inviteCANCEL = null;
    private CancelWaitTimerTask cancelTimerTask = null;
    private DialogWrapper dialogWrapper;
    private SipActivityHandle activityHandle = null;
    private static long cancelWait = 5000L;
    private static Timer cancelTimer = new Timer();
    private SipResourceAdaptor sipResourceAdaptor;

    public static void setCancelWait(long timeout) {
        cancelWait = timeout;
    }

    public ServerTransactionWrapper(ServerTransaction ST, DialogWrapper dialogWrapper, SipResourceAdaptor sipResourceAdaptor) {
        this.realTransaction = ST;
        this.dialogWrapper = dialogWrapper;
        ST.setApplicationData((Object)this);
        this.sipResourceAdaptor = sipResourceAdaptor;
        this.serviceContainer = SleeContainer.lookupFromJndi();
        this.realTransaction.setApplicationData((Object)this);
        this.activityHandle = new SipActivityHandle(ST.getBranchId() + "_" + ST.getRequest().getMethod());
    }

    public Transaction getRealTransaction() {
        return this.realTransaction;
    }

    public void setDialogWrapper(DialogWrapper dialogWrapper) {
        this.dialogWrapper = dialogWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(Response arg0) throws SipException, InvalidArgumentException {
        boolean gotToFire = false;
        try {
            if (this.dialogWrapper != null) {
                this.dialogWrapper.startStateEventFireSequence();
            }
            this.realTransaction.sendResponse(arg0);
            gotToFire = true;
            if (this.dialogWrapper == null) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n---------------------------------------\nSENDING RESPONSE:\n" + arg0 + "\n---------------------------------------"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\n-----------------------------------------\nOld State: " + this.dialogWrapper.getLastState() + "\nNew State: " + this.dialogWrapper.getState() + "\n--------------------------------------"));
            }
            this.dialogWrapper.fireDialogStateEvent(arg0);
        }
        finally {
            if (!gotToFire) {
                this.dialogWrapper.endStateEventFireSequence();
            }
        }
    }

    public void enableRetransmissionAlerts() throws SipException {
        this.realTransaction.enableRetransmissionAlerts();
    }

    public Dialog getDialog() {
        return this.dialogWrapper;
    }

    public TransactionState getState() {
        return this.realTransaction.getState();
    }

    public int getRetransmitTimer() throws UnsupportedOperationException {
        return this.realTransaction.getRetransmitTimer();
    }

    public void setRetransmitTimer(int arg0) throws UnsupportedOperationException {
        this.realTransaction.setRetransmitTimer(arg0);
    }

    public String getBranchId() {
        return this.realTransaction.getBranchId();
    }

    public Request getRequest() {
        return this.realTransaction.getRequest();
    }

    public void setApplicationData(Object arg0) {
        this.applicationData = arg0;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void terminate() throws ObjectInUseException {
        this.realTransaction.terminate();
    }

    public String toString() {
        return "[TransactionW WRAPPED[" + this.realTransaction + "] BRANCHID[" + this.realTransaction.getBranchId() + "] STATE[" + this.realTransaction.getState() + "] DIALOG{ " + this.dialogWrapper + " } ]";
    }

    public void setCancel(RequestEventWrapper cancel) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n XxX Setting cancel to:" + (Object)((Object)cancel) + " for tx:" + this.realTransaction.getBranchId() + "_" + this.realTransaction.getRequest().getMethod()));
        }
        this.inviteCANCEL = cancel;
        if (this.inviteCANCEL == null) {
            this.cancelTimerTask.cancel();
            this.cancelTimerTask = null;
        } else {
            this.cancelTimerTask = new CancelWaitTimerTask(this.inviteCANCEL, this, this.sipResourceAdaptor.getSipFactoryProvider(), this.sipResourceAdaptor.getSleeEndpoint(), this.sipResourceAdaptor.getBootstrapContext().getEventLookupFacility(), logger);
            cancelTimer.schedule((TimerTask)this.cancelTimerTask, cancelWait);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n XxX CANCEL SET");
            logger.debug((Object)("======= STAGE: \n" + (Object)((Object)this.inviteCANCEL) + "\n" + this.cancelTimerTask + "\n=========="));
        }
    }

    public void processCancelOnEventProcessingFailed() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n XxX processCancelOnEventProcessingFailed called for tx:" + this.realTransaction.getBranchId() + "_" + this.realTransaction.getRequest().getMethod()));
            logger.debug((Object)("======= STAGE: \n" + (Object)((Object)this.inviteCANCEL) + "\n" + this.cancelTimerTask + "\n=========="));
        }
        if (this.inviteCANCEL == null) {
            return;
        }
        this.cancelTimerTask.cancel();
        if (!this.cancelTimerTask.hasRun()) {
            this.cancelTimerTask.run();
        }
        this.cancelTimerTask = null;
        this.inviteCANCEL = null;
    }

    public void processCancelOnEventProcessingSucess() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n XxX processCancelOnEventProcessingSucess() called for tx:" + this.realTransaction.getBranchId() + "_" + this.realTransaction.getRequest().getMethod()));
            logger.debug((Object)("======= STAGE: \n" + (Object)((Object)this.inviteCANCEL) + "\n" + this.cancelTimerTask + "\n=========="));
        }
        if (this.inviteCANCEL == null) {
            return;
        }
        this.cancelTimerTask.cancel();
        if (!this.cancelTimerTask.hasRun()) {
            this.cancelTimerTask.run();
        }
        this.cancelTimerTask = null;
        this.inviteCANCEL = null;
    }

    public void processCancelOnActivityEnd() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n XxX processCancelOnActivityEnd() called for tx:" + this.realTransaction.getBranchId() + "_" + this.realTransaction.getRequest().getMethod()));
            logger.debug((Object)("======= STAGE: \n" + (Object)((Object)this.inviteCANCEL) + "\n" + this.cancelTimerTask + "\n=========="));
        }
        if (this.inviteCANCEL == null) {
            return;
        }
        this.cancelTimerTask.cancel();
        this.cancelTimerTask = null;
        this.inviteCANCEL = null;
    }

    public SipActivityHandle getActivityHandle() {
        return this.activityHandle;
    }
}

