/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip;

import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Transaction;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportAlreadySupportedException;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.resource.ActivityHandle;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.SipResourceAdaptor;
import org.mobicents.slee.resource.sip.SipStackProxy;
import org.mobicents.slee.resource.sip.wrappers.ClientTransactionWrapper;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.SecretWrapperInterface;
import org.mobicents.slee.resource.sip.wrappers.ServerTransactionWrapper;

public class SipProviderProxy
implements SipProvider {
    private Logger logger = Logger.getLogger(SipProviderProxy.class);
    SipProvider provider = null;
    SipStack stack = null;
    SipResourceAdaptor sipResourceAdaptor;
    TransactionManager txMgr = null;

    public void release() {
        ((SipStackProxy)this.stack).release();
        this.provider = null;
        this.stack = null;
    }

    public SipProviderProxy(SipProvider provider, SipResourceAdaptor sipResourceAdaptor) {
        this.provider = provider;
        this.sipResourceAdaptor = sipResourceAdaptor;
        this.stack = new SipStackProxy(provider.getSipStack(), this);
        this.txMgr = SleeContainer.getTransactionManager();
    }

    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        throw new SecurityException();
    }

    public ListeningPoint getListeningPoint() {
        return this.provider.getListeningPoints()[0];
    }

    public CallIdHeader getNewCallId() {
        return this.provider.getNewCallId();
    }

    public ListeningPoint getListeningPoint(String transport) {
        return this.provider.getListeningPoint(transport);
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        return this.getNewClientTransaction(request, false);
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        return this.getNewServerTransaction(request, false);
    }

    public Dialog getNewDialog(Transaction transaction) throws SipException {
        return this.getNewDialog(transaction, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTransaction getNewClientTransaction(Request request, boolean raCreates) throws TransactionUnavailableException {
        ClientTransaction t = this.provider.getNewClientTransaction(request);
        Dialog dialog = t.getDialog();
        DialogWrapper dialogWrapper = null;
        if (dialog != null && (dialogWrapper = (DialogWrapper)dialog.getApplicationData()) == null) {
            dialogWrapper = new DialogWrapper(dialog, this.sipResourceAdaptor);
        }
        ClientTransactionWrapper CTW = new ClientTransactionWrapper(t, dialogWrapper);
        SipActivityHandle SAH = CTW.getActivityHandle();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("\n === CREATED ACTIVITY FOR:\"" + t.getBranchId() + "\""));
            this.logger.debug((Object)("\n=== SAH:\"" + SAH + "\""));
        }
        this.sipResourceAdaptor.getActivities().put(SAH, CTW);
        t.setApplicationData((Object)CTW);
        boolean begin = false;
        if (!raCreates) {
            try {
                if (this.txMgr.getTransaction() == null) {
                    this.txMgr.begin();
                    begin = true;
                }
                this.sipResourceAdaptor.getSleeEndpoint().activityStartedSuspended((ActivityHandle)SAH);
            }
            catch (Exception e) {
                this.logger.error((Object)("getNewClientTransaction(" + request + ")"), (Throwable)e);
            }
            finally {
                if (begin) {
                    try {
                        this.txMgr.commit();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    catch (RollbackException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicMixedException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicRollbackException e) {
                        e.printStackTrace();
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return CTW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTransaction getNewServerTransaction(Request request, boolean raCreates) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        ServerTransaction t = this.provider.getNewServerTransaction(request);
        Dialog dialog = t.getDialog();
        DialogWrapper dialogWrapper = null;
        if (dialog != null && (dialogWrapper = (DialogWrapper)dialog.getApplicationData()) == null) {
            dialogWrapper = new DialogWrapper(dialog, this.sipResourceAdaptor);
        }
        ServerTransactionWrapper STW = new ServerTransactionWrapper(t, dialogWrapper, this.sipResourceAdaptor);
        SipActivityHandle SAH = STW.getActivityHandle();
        this.sipResourceAdaptor.getActivities().put(SAH, STW);
        t.setApplicationData((Object)STW);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"\n === CREATED ACTIVITY FOR:\"\"");
            this.logger.debug((Object)("\n=== SAH:\"" + SAH + "\""));
        }
        boolean begin = false;
        if (!raCreates) {
            try {
                if (this.txMgr.getTransaction() == null) {
                    this.txMgr.begin();
                    begin = true;
                }
                this.sipResourceAdaptor.getSleeEndpoint().activityStartedSuspended((ActivityHandle)SAH);
            }
            catch (Exception e) {
                this.logger.error((Object)("getNewServerTransaction(" + request + ");"), (Throwable)e);
            }
            finally {
                if (begin) {
                    try {
                        this.txMgr.commit();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    catch (RollbackException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicMixedException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicRollbackException e) {
                        e.printStackTrace();
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return STW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog getNewDialog(Transaction transaction, boolean raCreates) throws SipException {
        SecretWrapperInterface transactionWrapper = (SecretWrapperInterface)transaction;
        Transaction realTx = transactionWrapper.getRealTransaction();
        Dialog dial = realTx.getDialog();
        DialogWrapper DW = null;
        if (dial != null && dial.getApplicationData() != null && dial.getApplicationData() instanceof DialogWrapper) {
            DW = (DialogWrapper)dial.getApplicationData();
            DW.renew();
            return DW;
        }
        dial = this.provider.getNewDialog(realTx);
        DW = new DialogWrapper(dial, this.sipResourceAdaptor);
        String dialID = DW.getDialogId();
        transactionWrapper.setDialogWrapper(DW);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("==================== DIALOG: " + dial + " : " + dialID + " ==============="));
        }
        SipActivityHandle SAH = DW.getActivityHandle();
        this.sipResourceAdaptor.getActivities().put(SAH, DW);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("\n === CREATED ACTIVITY FOR:\"" + dialID + "\""));
            this.logger.debug((Object)("\n=== SAH:\"" + SAH + "\""));
        }
        boolean begin = false;
        if (!raCreates) {
            try {
                if (this.txMgr.getTransaction() == null) {
                    this.txMgr.begin();
                    begin = true;
                }
                this.sipResourceAdaptor.getSleeEndpoint().activityStartedSuspended((ActivityHandle)SAH);
            }
            catch (Exception e) {
                this.logger.error((Object)("getNewDialog(" + transaction + ")"), (Throwable)e);
            }
            finally {
                if (begin) {
                    try {
                        this.txMgr.commit();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    catch (RollbackException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicMixedException e) {
                        e.printStackTrace();
                    }
                    catch (HeuristicRollbackException e) {
                        e.printStackTrace();
                    }
                    catch (SystemException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return DW;
    }

    public SipStack getSipStack() {
        return this.stack;
    }

    public void removeSipListener(SipListener sipListener) {
        throw new SecurityException();
    }

    public void sendRequest(Request request) throws SipException {
        this.provider.sendRequest(request);
    }

    public void sendResponse(Response response) throws SipException {
        this.provider.sendResponse(response);
    }

    public void setListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        throw new ObjectInUseException();
    }

    public ListeningPoint[] getListeningPoints() {
        return this.provider.getListeningPoints();
    }

    public void addListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException, TransportAlreadySupportedException {
        throw new ObjectInUseException();
    }

    public void removeListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        throw new ObjectInUseException();
    }

    public void setAutomaticDialogSupportEnabled(boolean booean) {
        this.provider.setAutomaticDialogSupportEnabled(true);
    }
}

