/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.sip.wrappers;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import org.mobicents.slee.resource.sip.SipActivityHandle;
import org.mobicents.slee.resource.sip.wrappers.DialogWrapper;
import org.mobicents.slee.resource.sip.wrappers.SecretWrapperInterface;

public class ClientTransactionWrapper
implements ClientTransaction,
SecretWrapperInterface {
    private static final long serialVersionUID = 1L;
    private ClientTransaction realTransaction = null;
    private Object applicationData = null;
    private DialogWrapper dialogWrapper;
    private SipActivityHandle activityHandle = null;

    public ClientTransactionWrapper(ClientTransaction CT, DialogWrapper dialogWrapper) {
        this.realTransaction = CT;
        CT.setApplicationData((Object)this);
        this.dialogWrapper = dialogWrapper;
        this.activityHandle = new SipActivityHandle(CT.getBranchId() + "_" + CT.getRequest().getMethod());
    }

    public Transaction getRealTransaction() {
        return this.realTransaction;
    }

    public void setDialogWrapper(DialogWrapper dialogWrapper) {
        this.dialogWrapper = dialogWrapper;
    }

    public void sendRequest() throws SipException {
        this.realTransaction.sendRequest();
        if (this.dialogWrapper != null) {
            this.dialogWrapper.renew();
        }
    }

    public Request createCancel() throws SipException {
        return this.realTransaction.createCancel();
    }

    public Request createAck() throws SipException {
        return this.realTransaction.createAck();
    }

    public Dialog getDialog() {
        return this.dialogWrapper;
    }

    public TransactionState getState() {
        return this.realTransaction.getState();
    }

    public int getRetransmitTimer() throws UnsupportedOperationException {
        return this.realTransaction.getRetransmitTimer();
    }

    public void setRetransmitTimer(int arg0) throws UnsupportedOperationException {
        this.realTransaction.setRetransmitTimer(arg0);
    }

    public String getBranchId() {
        return this.realTransaction.getBranchId();
    }

    public Request getRequest() {
        return this.realTransaction.getRequest();
    }

    public void setApplicationData(Object appData) {
        this.applicationData = appData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void terminate() throws ObjectInUseException {
        this.realTransaction.terminate();
    }

    public SipActivityHandle getActivityHandle() {
        return this.activityHandle;
    }

    public String toString() {
        return "[TransactionW[" + super.toString() + "] WRAPPED[" + this.realTransaction + "] BRANCHID[" + this.realTransaction.getBranchId() + "] STATE[" + this.realTransaction.getState() + "] DIALOG{ " + this.dialogWrapper + " } ]";
    }
}

