/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.mobicents.media.Format;
import org.mobicents.media.format.AudioFormat;
import org.mobicents.media.server.impl.dsp.audio.g729.CodecMBean;
import org.mobicents.media.server.impl.dsp.audio.g729.G729Factory;

public class Codec
extends ServiceMBeanSupport
implements CodecMBean {
    private String jndiName;
    private G729Factory codecFactory;
    private Logger logger = Logger.getLogger(Codec.class);

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (this.getState() == 3) {
            this.unbind(oldName);
            try {
                this.rebind();
            }
            catch (NamingException e) {
                NamingException ne = new NamingException("Failed to update JNDI name");
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    public Format[] getInputFormats() {
        return new AudioFormat[0];
    }

    public Format[] getOutputFormats() {
        return new AudioFormat[0];
    }

    public void startService() throws Exception {
        this.logger.info((Object)"Deploying codec: G729");
        this.codecFactory = new G729Factory();
        this.rebind();
    }

    public void stopService() {
        this.unbind(this.jndiName);
        this.logger.info((Object)"Undeployed codec: G729 ");
    }

    private void rebind() throws NamingException {
        Context ctx = new InitialContext();
        String[] tokens = this.jndiName.split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (tokens[i].trim().length() <= 0) continue;
            try {
                ctx = (Context)ctx.lookup(tokens[i]);
                continue;
            }
            catch (NamingException e) {
                ctx = ctx.createSubcontext(tokens[i]);
            }
        }
        ctx.bind(tokens[tokens.length - 1], (Object)this.codecFactory);
        this.logger.info((Object)("Deployed codec: G729, jndi=" + this.jndiName));
    }

    private void unbind(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            initialContext.unbind(jndiName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

