/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import org.apache.log4j.Logger;
import org.mobicents.media.Buffer;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.codec.g729.Bits;
import org.mobicents.media.server.impl.codec.g729.DecLD8K;
import org.mobicents.media.server.impl.codec.g729.IntegerPointer;
import org.mobicents.media.server.impl.codec.g729.PParity;
import org.mobicents.media.server.impl.codec.g729.PostFil;
import org.mobicents.media.server.impl.codec.g729.PostPro;
import org.mobicents.media.server.impl.codec.g729.Util;
import org.mobicents.media.server.impl.dsp.audio.g729.CircularBuffer;
import org.mobicents.media.server.spi.dsp.Codec;

public class Decoder
implements Codec {
    int frame = 0;
    CircularBuffer circular = new CircularBuffer(16000);
    float[] synth_buf = new float[90];
    int synth;
    int[] parm = new int[12];
    short[] serial = new short[82];
    float[] Az_dec = new float[22];
    int ptr_Az;
    IntegerPointer t0_first = new IntegerPointer();
    float[] pst_out = new float[80];
    int voicing;
    IntegerPointer sf_voic = new IntegerPointer(0);
    DecLD8K decLD = new DecLD8K();
    PostFil postFil = new PostFil();
    PostPro postPro = new PostPro();
    private transient Logger logger = Logger.getLogger(Decoder.class);

    public Decoder() {
        for (int i = 0; i < 10; ++i) {
            this.synth_buf[i] = 0.0f;
        }
        this.synth = 10;
        this.decLD.init_decod_ld8k();
        this.postFil.init_post_filter();
        this.postPro.init_post_process();
        this.voicing = 60;
    }

    public Format[] getSupportedInputFormats() {
        Format[] formats = new Format[]{Codec.G729};
        return formats;
    }

    public Format[] getSupportedOutputFormats(Format fmt) {
        Format[] formats = new Format[]{Codec.LINEAR_AUDIO};
        return formats;
    }

    public Format[] getSupportedInputFormats(Format fmt) {
        Format[] formats = new Format[]{Codec.G729};
        return formats;
    }

    public Format[] getSupportedOutputFormats() {
        Format[] formats = new Format[]{Codec.LINEAR_AUDIO};
        return formats;
    }

    public void process(Buffer buffer) {
        byte[] data = (byte[])buffer.getData();
        int offset = buffer.getOffset();
        int length = buffer.getLength();
        byte[] media = new byte[length - offset];
        System.arraycopy(data, 0, media, 0, media.length);
        this.circular.addData(media);
        byte[] speechWindow = this.circular.getData(20);
        byte[] resultBytes = null;
        if (speechWindow != null) {
            int q;
            byte[] one = new byte[10];
            byte[] two = new byte[10];
            for (q = 0; q < 10; ++q) {
                one[q] = speechWindow[q];
                two[q] = speechWindow[q + 10];
            }
            if ((one = this.process(one)).length != (two = this.process(two)).length) {
                throw new RuntimeException("The two frames are not equal in size!");
            }
            resultBytes = new byte[one.length + two.length];
            for (q = 0; q < one.length; ++q) {
                resultBytes[q] = one[q];
                resultBytes[q + one.length] = two[q];
            }
        } else {
            resultBytes = new byte[]{};
        }
        buffer.setData((Object)resultBytes);
        buffer.setOffset(0);
        buffer.setLength(resultBytes.length);
    }

    public byte[] process(byte[] media) {
        int i;
        this.serial = Bits.fromRealBits(media);
        ++this.frame;
        Bits.bits2prm_ld8k(this.serial, 2, this.parm, 1);
        this.parm[0] = 0;
        for (i = 2; i < 82; ++i) {
            if (this.serial[i] != 0) continue;
            this.parm[0] = 1;
        }
        this.parm[4] = PParity.check_parity_pitch(this.parm[3], this.parm[4]);
        this.decLD.decod_ld8k(this.parm, 0, this.voicing, this.synth_buf, this.synth, this.Az_dec, this.t0_first);
        this.voicing = 0;
        this.ptr_Az = 0;
        for (i = 0; i < 80; i += 40) {
            this.postFil.post(this.t0_first.value, this.synth_buf, this.synth + i, this.Az_dec, this.ptr_Az, this.pst_out, i, this.sf_voic);
            if (this.sf_voic.value != 0) {
                this.voicing = this.sf_voic.value;
            }
            this.ptr_Az += 11;
        }
        Util.copy(this.synth_buf, 80, this.synth_buf, 0, 10);
        this.postPro.post_process(this.pst_out, 80);
        return Util.floatArrayToByteArray(this.pst_out, 80);
    }
}

