/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.Format;
import org.mobicents.media.server.impl.dsp.audio.g729.Decoder;
import org.mobicents.media.server.impl.dsp.audio.g729.Encoder;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.dsp.CodecFactory;

public class G729Factory
implements CodecFactory {
    private static List<Codec> codecs = new ArrayList<Codec>();

    private static boolean matches(Format[] supported, Format input) {
        for (int i = 0; i < supported.length; ++i) {
            if (!supported[i].matches(input)) continue;
            return true;
        }
        return false;
    }

    public synchronized Codec getCodec(Format inputFmt, Format outputFmt) {
        for (Codec codec : codecs) {
            if (!G729Factory.matches(codec.getSupportedInputFormats(), inputFmt) || !G729Factory.matches(codec.getSupportedOutputFormats(inputFmt), outputFmt)) continue;
            Class<?> cls = codec.getClass();
            try {
                return (Codec)cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        codecs.add(new Encoder());
        codecs.add(new Decoder());
    }
}

