/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.g729;

public class CircularBuffer {
    private byte[] buffer;
    private int cursor = 0;
    private int availableData = 0;

    public CircularBuffer(int size) {
        this.buffer = new byte[size];
    }

    public synchronized void addData(byte[] data) {
        boolean zeros = false;
        if (!zeros) {
            for (int q = 0; q < data.length; ++q) {
                this.buffer[(this.cursor + q) % this.buffer.length] = data[q];
            }
            this.availableData += data.length;
            if (this.availableData > this.buffer.length) {
                this.availableData = this.buffer.length;
            }
        }
    }

    public synchronized byte[] getData(int size) {
        if (this.availableData < size) {
            return null;
        }
        byte[] data = new byte[size];
        for (int q = 0; q < data.length; ++q) {
            data[q] = this.buffer[(this.cursor + q) % this.buffer.length];
        }
        this.cursor = (this.cursor + data.length) % this.buffer.length;
        this.availableData -= size;
        return data;
    }
}

