/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.BufferFactory;
import org.mobicents.media.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffer
implements Serializable {
    public static final int FLAG_EOM = 1;
    public static final int FLAG_DISCARD = 2;
    public static final int FLAG_SILENCE = 4;
    public static final int FLAG_SID = 8;
    public static final int FLAG_KEY_FRAME = 16;
    public static final int FLAG_NO_DROP = 32;
    public static final int FLAG_NO_WAIT = 64;
    public static final int FLAG_NO_SYNC = 96;
    public static final int FLAG_SYSTEM_TIME = 128;
    public static final int FLAG_RELATIVE_TIME = 256;
    public static final int FLAG_FLUSH = 512;
    public static final int FLAG_SYSTEM_MARKER = 1024;
    public static final int FLAG_RTP_BINARY = 2048;
    public static final int FLAG_RTP_TIME = 4096;
    public static final int FLAG_BUF_OVERFLOWN = 8192;
    public static final int FLAG_BUF_UNDERFLOWN = 16384;
    public static final int FLAG_LIVE_DATA = 32768;
    public static final long TIME_UNKNOWN = -1L;
    public static final long SEQUENCE_UNKNOWN = 0x7FFFFFFFFFFFFFFEL;
    private long timeStamp = 0L;
    private long duration = 0L;
    private byte[] data;
    private int offset;
    private int length;
    private Format format;
    private int flags = 0;
    private Object header = null;
    private BufferFactory factory;
    private long sequenceNumber = 0x7FFFFFFFFFFFFFFEL;
    private List<byte[]> rtpPackets = null;

    public List<byte[]> getRtpPackets() {
        return this.rtpPackets;
    }

    public void addRtpPacket(byte[] data) {
        if (this.rtpPackets == null) {
            this.rtpPackets = new ArrayList<byte[]>();
        }
        this.rtpPackets.add(data);
    }

    public void setFactory(BufferFactory factory) {
        this.factory = factory;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isEOM() {
        return (this.flags & 1) != 0;
    }

    public void setEOM(boolean eom) {
        this.flags = eom ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public boolean isDiscard() {
        return (this.flags & 2) != 0;
    }

    public void setDiscard(boolean discard) {
        this.flags = discard ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public Object getHeader() {
        return this.header;
    }

    public void setHeader(Object header) {
        this.header = header;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setSequenceNumber(long number) {
        this.sequenceNumber = number;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void copy(Buffer buffer) {
        this.copy(buffer, false);
    }

    public void copy(Buffer buffer, boolean swapData) {
        this.duration = buffer.duration;
        this.flags = buffer.flags;
        this.format = buffer.format;
        this.header = buffer.header;
        this.sequenceNumber = buffer.sequenceNumber;
        this.timeStamp = buffer.timeStamp;
        this.length = buffer.length;
        this.offset = buffer.offset;
        if (buffer.getData() != null) {
            this.data = new byte[buffer.getData().length];
            System.arraycopy(buffer.getData(), 0, this.data, 0, this.data.length);
        }
    }

    public Object clone() {
        Buffer result = new Buffer();
        result.duration = this.duration;
        result.flags = this.flags;
        result.format = this.format;
        result.header = Buffer.dupData(this.header, true);
        result.sequenceNumber = this.sequenceNumber;
        result.timeStamp = this.timeStamp;
        result.factory = this.factory;
        return result;
    }

    private static Object dupData(Object data, boolean standardTypesOnly) {
        Object[] result;
        int len;
        if (data == null) {
            return null;
        }
        if (!data.getClass().isArray()) {
            throw new IllegalArgumentException();
        }
        if (data.getClass() == byte[].class) {
            len = ((byte[])data).length;
            result = new byte[len];
        } else if (data.getClass() == int[].class) {
            len = ((int[])data).length;
            result = new int[len];
        } else if (data.getClass() == short[].class) {
            len = ((short[])data).length;
            result = new short[len];
        } else if (!standardTypesOnly && data.getClass() == float[].class) {
            len = ((float[])data).length;
            result = new float[len];
        } else if (!standardTypesOnly && data.getClass() == double[].class) {
            len = ((double[])data).length;
            result = new double[len];
        } else if (!standardTypesOnly && data.getClass() == boolean[].class) {
            len = ((boolean[])data).length;
            result = new boolean[len];
        } else if (!standardTypesOnly && data.getClass() == long[].class) {
            len = ((long[])data).length;
            result = new long[len];
        } else if (!standardTypesOnly && data.getClass() == char[].class) {
            len = ((char[])data).length;
            result = new char[len];
        } else {
            return data;
        }
        System.arraycopy(data, 0, result, 0, len);
        return result;
    }

    public String toString() {
        return "Buffer[fmt=" + this.format + ", timestamp=" + this.timeStamp + ", seq=" + this.sequenceNumber + ", size= " + this.length + "]";
    }

    public void dispose() {
        if (this.factory != null) {
            this.factory.deallocate(this);
        }
    }
}

