/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media;

import java.util.ArrayList;
import org.mobicents.media.Buffer;

public class BufferFactory {
    private int BUFF_SIZE = 8192;
    private ArrayList<Buffer> list = new ArrayList();
    private int size;

    public BufferFactory(int size) {
        this.size = size;
        this.init();
    }

    public BufferFactory(int size, int buffSize) {
        this.size = size;
        this.BUFF_SIZE = buffSize;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.size; ++i) {
            Buffer buffer = new Buffer();
            buffer.setFactory(this);
            this.list.add(buffer);
        }
    }

    public Buffer allocate() {
        Buffer buffer = null;
        if (!this.list.isEmpty()) {
            buffer = this.list.remove(0);
        }
        if (buffer != null) {
            return buffer;
        }
        buffer = new Buffer();
        buffer.setFactory(this);
        return buffer;
    }

    public void deallocate(Buffer buffer) {
        if (this.list.size() < this.size && buffer != null) {
            buffer.setDiscard(false);
            buffer.setHeader(null);
            this.list.add(buffer);
        }
    }
}

