/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media;

import java.io.Serializable;
import org.mobicents.media.FormatUtils;

public class Format
implements Cloneable,
Serializable {
    public static final int NOT_SPECIFIED = -1;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected String encoding;
    private long encodingCode;
    private int hash;
    public static final Format ANY = new Format("ANY");
    public static final Format RAW_RTP = new Format("RAW_RTP");
    protected int frameRate = -1;
    public static final int FORMAT_HASHMAP_DEFAULT_INITIAL_CAPACITY = 8;
    public static final float FORMAT_HASHMAP_DEFAULT_LOAD_FACTOR = 1.0f;

    public Format(String encoding) {
        this.encoding = encoding;
        this.hash = encoding.hashCode();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(int frameRate) {
        this.frameRate = frameRate;
    }

    public boolean equals(Object format) {
        return format.hashCode() == this.hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean matches(Format format) {
        if (format == null) {
            return false;
        }
        if (this == ANY) {
            return true;
        }
        if (format == ANY) {
            return true;
        }
        return this.encoding.equals(format.encoding) || this.encoding == null || format.encoding == null || this.isSameEncoding(format);
    }

    public boolean isSameEncoding(Format other) {
        if (other == null) {
            return false;
        }
        if (other.encoding == null) {
            return false;
        }
        if (this.encoding == null) {
            return false;
        }
        if (other.encoding.equalsIgnoreCase(this.encoding)) {
            return true;
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (other.encodingCode == 0L) {
            other.encodingCode = this.getEncodingCode(other.encoding);
        }
        return this.encodingCode == other.encodingCode;
    }

    public boolean isSameEncoding(String encoding) {
        if (encoding == null) {
            return false;
        }
        if (this.encoding == null) {
            return false;
        }
        if (encoding.equals(this.encoding)) {
            return true;
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        return this.encodingCode == this.getEncodingCode(encoding);
    }

    private long getEncodingCode(String enc) {
        if (enc == null) {
            return 0L;
        }
        return FormatUtils.stringEncodingCodeVal(enc);
    }

    public Format relax() {
        return (Format)this.clone();
    }

    public Object clone() {
        return new Format(this.encoding);
    }

    public String toString() {
        return this.getEncoding();
    }
}

