/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.mobicents.media.format.AudioFormat;

public class Utils {
    public static final String _FILE_SCHEME_ = "file";
    public static final String _FILE_SCHEME_CONCAT_ = "file:/";
    private static final Pattern schemePattern = Pattern.compile("\\w\\w+:.*");
    private static final Pattern windowsFilePattern = Pattern.compile("\\w:.*");

    public static AudioFormat parseFormat(String formatDesc) {
        String[] tokens = formatDesc.split(",");
        if (tokens.length != 4) {
            throw new IllegalArgumentException("Invalid format definition: " + formatDesc);
        }
        String encoding = tokens[0];
        String srDesc = tokens[1].substring(0, tokens[1].indexOf("Hz"));
        double sampleRate = Double.parseDouble(srDesc.trim());
        String szDesc = tokens[2].substring(0, tokens[2].indexOf("-bits"));
        int sampleSize = Integer.parseInt(szDesc.trim());
        int channels = 1;
        if (tokens[3].trim().equals("Mono")) {
            channels = 1;
        } else if (tokens[3].trim().equals("Stereo")) {
            channels = 2;
        } else {
            throw new IllegalArgumentException("Invalid format description: " + tokens[3]);
        }
        return new AudioFormat(encoding, sampleRate, sampleSize, channels);
    }

    public static String doMessage(Throwable t) {
        StringBuffer sb = new StringBuffer();
        int tick = 0;
        Throwable e = t;
        do {
            StackTraceElement[] trace = e.getStackTrace();
            if (tick++ == 0) {
                sb.append(e.getClass().getCanonicalName() + ":" + e.getLocalizedMessage() + "\n");
            } else {
                sb.append("Caused by: " + e.getClass().getCanonicalName() + ":" + e.getLocalizedMessage() + "\n");
            }
            for (StackTraceElement ste : trace) {
                sb.append("\t" + ste + "\n");
            }
        } while ((e = e.getCause()) != null);
        return sb.toString();
    }

    public static final URL getAbsoluteURL(String parrent, String passedURI) throws URISyntaxException, MalformedURLException {
        if (Pattern.matches(schemePattern.pattern(), passedURI)) {
            return new URL(passedURI);
        }
        if (Pattern.matches(windowsFilePattern.pattern(), passedURI) || passedURI.startsWith("/")) {
            return new URL(_FILE_SCHEME_CONCAT_ + passedURI);
        }
        String absPath = parrent + passedURI;
        File f = new File(absPath);
        URL l = f.toURL();
        return l;
    }

    public static void addObject(Object[] target, Object o) {
        for (int index = 0; index < target.length; ++index) {
            if (target[index] != null) continue;
            target[index] = o;
            return;
        }
        throw new IllegalStateException("To many objects!");
    }

    public static boolean removeObject(Object[] target, Object o) {
        for (int index = 0; index < target.length; ++index) {
            if (target[index] != o) continue;
            target[index] = null;
            return true;
        }
        return false;
    }
}

