/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.resource.ss7;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mobicents.media.server.spi.resource.ss7.Mtp2;
import org.mobicents.media.server.spi.resource.ss7.Mtp2Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkSet
implements Mtp2Listener {
    private String linksetName = "DEFAULT_LINKSET";
    private byte linkSetID = (byte)-1;
    private ArrayList<Mtp2> links = new ArrayList(16);
    private ArrayList<Mtp2> activeLinks = new ArrayList(16);
    private transient Mtp2 activatingLink;
    private int opc;
    private int dpc;

    public LinkSet(String linksetName, byte linkSetID, int opc, int dpc, List<Mtp2> linksList) {
        this.linksetName = linksetName;
        this.linkSetID = linkSetID;
        this.opc = opc;
        this.dpc = dpc;
        if (linksList.size() > 16) {
            throw new IllegalArgumentException("Linkset can have only up to 16 links!");
        }
        for (Mtp2 mtp2 : linksList) {
            this.links.add(mtp2);
            mtp2.setLinkSet(this);
            Collections.sort(this.links, new Mtp2Comparator());
        }
    }

    public void threadTick(long thisTickStamp) {
        for (Mtp2 mtp2 : this.links) {
            mtp2.threadTick(thisTickStamp);
        }
    }

    public ArrayList<Mtp2> getLinks() {
        return this.links;
    }

    public ArrayList<Mtp2> getActiveLinks() {
        return this.activeLinks;
    }

    public void activateLink() {
        if (this.activatingLink == null) {
            for (Mtp2 mtp2 : this.links) {
                if (mtp2.getState() != 0 || mtp2.isT17()) continue;
                mtp2.start_T17();
                this.activatingLink = mtp2;
                break;
            }
        }
    }

    @Override
    public void linkFailed(Mtp2 mtp2) {
        this.activeLinks.remove(mtp2);
        if (this.activatingLink == mtp2) {
            this.activatingLink = null;
        }
    }

    @Override
    public void linkInService(Mtp2 mtp2) {
        this.activeLinks.add(mtp2.getSls(), mtp2);
        if (this.activatingLink == mtp2) {
            this.activatingLink = null;
        }
    }

    public String getName() {
        return this.linksetName;
    }

    public byte getId() {
        return this.linkSetID;
    }

    public int getOpc() {
        return this.opc;
    }

    public int getDpc() {
        return this.dpc;
    }

    @Override
    public void onMessage(int sio, byte[] sif, Mtp2 mtp2) {
    }

    public void start() {
        if (this.linkSetID == -1) {
            throw new IllegalStateException("Linkset ID MUST be set.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Mtp2Comparator
    implements Comparator<Mtp2> {
        private Mtp2Comparator() {
        }

        @Override
        public int compare(Mtp2 o1, Mtp2 o2) {
            if (o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            return o1.getSls() - o2.getSls();
        }
    }
}

