/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.spi.resource.ss7;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.media.server.spi.resource.ss7.MTPThreadFactory;

public class Utils {
    public static final byte _VALUE_NOT_SET = -1;
    private static final Logger logger = Logger.getLogger(Utils.class);
    private static final Utils _INSTANCE_ = new Utils();
    private StringBuilder loggBuilder = new StringBuilder();
    private LinkedList<BufferHolder> dataHolder = new LinkedList();
    private Future debugFuture;
    private boolean enabledL2Debug = false;
    private boolean enableDataTrace = false;
    private boolean enabledL3Debug = false;
    private static final MTPThreadFactory timerThreadFactory = new MTPThreadFactory("MTPTimerTGroup", 10);
    private static final ScheduledExecutorService mtpTimer = Executors.newSingleThreadScheduledExecutor(timerThreadFactory);

    public static final String dump(ByteBuffer buff, int size, boolean asBits) {
        return Utils.dump(buff.array(), size, asBits);
    }

    public static final String dump(byte[] buff, int size, boolean asBits) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            String ss = null;
            ss = !asBits ? Integer.toHexString(buff[i] & 0xFF) : Integer.toBinaryString(buff[i] & 0xFF);
            ss = Utils.fillInZeroPrefix(ss, asBits);
            s = s + " " + ss;
        }
        return s;
    }

    public static final String fillInZeroPrefix(String ss, boolean asBits) {
        if (asBits) {
            if (ss.length() < 8) {
                for (int j = ss.length(); j < 8; ++j) {
                    ss = "0" + ss;
                }
            }
        } else if (ss.length() < 2) {
            ss = "0" + ss;
        }
        return ss;
    }

    public static final String dump(int[] buff, int size) {
        String s = "";
        for (int i = 0; i < size; ++i) {
            String ss = Integer.toHexString(buff[i] & 0xFF);
            if (ss.length() == 1) {
                ss = "0" + ss;
            }
            s = s + " " + ss;
        }
        return s;
    }

    public static void createTrace(Throwable t, StringBuilder sb, boolean top) {
        if (!top) {
            sb.append("\nCaused by: " + t.toString());
        }
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            sb.append("\tat " + trace[i]);
        }
        Throwable ourCause = t.getCause();
        if (ourCause != null) {
            Utils.createTrace(ourCause, sb, false);
        }
    }

    public static String createTrace(Throwable t) {
        StringBuilder sb = new StringBuilder();
        Utils.createTrace(t, sb, true);
        return sb.toString();
    }

    public static Utils getInstance() {
        return _INSTANCE_;
    }

    public boolean isEnabledL2Debug() {
        return this.enabledL2Debug;
    }

    public void setEnabledL2Debug(boolean enabledL2Debug) {
        this.enabledL2Debug = enabledL2Debug;
    }

    public boolean isEnableDataTrace() {
        return this.enableDataTrace;
    }

    public void setEnableDataTrace(boolean enableDataTrace) {
        this.enableDataTrace = enableDataTrace;
    }

    public boolean isEnabledL3Debug() {
        return this.enabledL3Debug;
    }

    public void setEnabledL3Debug(boolean enabledL3Debug) {
        this.enabledL3Debug = enabledL3Debug;
    }

    public void append(String s) {
        this.loggBuilder.append("\n" + s);
    }

    public void startDebug() {
        if (this.enabledL2Debug || this.enabledL3Debug) {
            this.debugFuture = mtpTimer.scheduleAtFixedRate(new LogginAction(), 1L, 1L, TimeUnit.SECONDS);
        }
    }

    public void stopDebug() {
        if (this.debugFuture != null) {
            this.debugFuture.cancel(false);
            this.debugFuture = null;
        }
    }

    public static ScheduledExecutorService getMtpTimer() {
        return mtpTimer;
    }

    public void addBuffer(int sls, String name, String linkSetName, int linkSetId, long currentTimeMillis, byte[] buff, int len) {
        BufferHolder bh = new BufferHolder(currentTimeMillis, buff, len, name, sls, linkSetName, linkSetId);
        this.dataHolder.add(bh);
    }

    private class BufferHolder {
        private long stamp;
        private byte[] buffer;
        private int len;
        private String linkName;
        private int linkSls = -1;
        private String linkSetName;
        private int linkSetId = -1;

        private BufferHolder(long stamp, byte[] buffer, int len, String linkName, int linkSls, String linkSetName, int linkSetId) {
            this.stamp = stamp;
            this.buffer = buffer;
            this.len = len;
            System.arraycopy(buffer, 0, this.buffer, 0, len);
            this.linkName = linkName;
            this.linkSls = linkSls;
            this.linkSetName = linkSetName;
            this.linkSetId = linkSetId;
        }

        public String toString() {
            return "T:" + this.stamp + ":" + this.linkName + ":" + this.linkSls + ":" + this.linkSetName + ":" + this.linkSetId + ":" + Utils.dump(this.buffer, this.len, false);
        }
    }

    private final class LogginAction
    implements Runnable {
        private LogginAction() {
        }

        public void run() {
            if ((Utils.this.enabledL2Debug || Utils.this.enabledL3Debug) && Utils.this.loggBuilder.length() > 0) {
                logger.info((Object)Utils.this.loggBuilder);
                Utils.this.loggBuilder = new StringBuilder();
            }
            if (Utils.this.enableDataTrace && Utils.this.enabledL2Debug && Utils.this.dataHolder.size() > 0) {
                StringBuilder sb = new StringBuilder();
                while (Utils.this.dataHolder.size() > 0) {
                    sb.append(Utils.this.dataHolder.remove(0)).append("\n");
                }
                logger.info((Object)("\n" + sb));
            }
        }
    }
}

