/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.mobicents.media.msc.common.MsLinkMode;
import org.mobicents.media.msc.common.MsLinkState;
import org.mobicents.media.msc.common.events.MsLinkEventCause;
import org.mobicents.media.msc.common.events.MsLinkEventID;
import org.mobicents.media.server.impl.common.ConnectionMode;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.impl.MsLinkEventImpl;

public class MsLinkImpl
implements MsLink {
    private static final long serialVersionUID = 6373269860176309745L;
    private final String id = new UID().toString();
    private MsSession session;
    private MsLinkMode mode;
    private MsLinkState state;
    protected ArrayList<MsLinkListener> linkListeners = new ArrayList();
    private Connection[] connections = new Connection[2];
    private Logger logger = Logger.getLogger(MsLinkImpl.class);
    private String[] endpoints = new String[2];

    public String getId() {
        return this.id;
    }

    public MsLinkImpl(MsSession session, MsLinkMode mode) {
        this.session = session;
        this.linkListeners.addAll(session.getProvider().getLinkListeners());
        this.mode = mode;
    }

    public MsSession getSession() {
        return this.session;
    }

    public MsLinkState getState() {
        return this.state;
    }

    public void fireMsLinkCreated() {
        this.state = MsLinkState.IDLE;
        this.sendEvent(MsLinkEventID.LINK_CREATED, MsLinkEventCause.NORMAL, null);
    }

    private void sendEvent(MsLinkEventID eventID, MsLinkEventCause cause, String msg) {
        MsLinkEventImpl evt = new MsLinkEventImpl(this, eventID, cause, msg);
        new Thread(evt).start();
    }

    public void join(String a, String b) {
        new Thread(new JoinTx(a, b)).start();
    }

    public String[] getEndpoints() {
        return this.endpoints;
    }

    public void release() {
        new Thread(new DropTx()).start();
        this.session.disassociateLink((MsLink)this);
    }

    public String toString() {
        return "MsLink{" + this.id + "}";
    }

    private ConnectionMode getMode(int end) {
        switch (this.mode) {
            case FULL_DUPLEX: {
                return ConnectionMode.SEND_RECV;
            }
            case HALF_DUPLEX: {
                return end == 0 ? ConnectionMode.SEND_ONLY : ConnectionMode.RECV_ONLY;
            }
        }
        return null;
    }

    private class DropTx
    implements Runnable {
        private DropTx() {
        }

        public void execute() {
            MsLinkImpl.this.logger.debug((Object)("Releasing connection " + MsLinkImpl.this.connections[1]));
            MsLinkImpl.this.connections[1].getEndpoint().deleteConnection(MsLinkImpl.this.connections[1].getId());
            MsLinkImpl.this.logger.debug((Object)("Releasing connection " + MsLinkImpl.this.connections[0]));
            MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
            MsLinkImpl.this.state = MsLinkState.INVALID;
            MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_DROPPED, MsLinkEventCause.NORMAL, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NDC.push((String)("RELEASE TX ID = " + MsLinkImpl.this.id));
            try {
                this.execute();
            }
            finally {
                NDC.pop();
                NDC.remove();
            }
        }
    }

    private class JoinTx
    implements Runnable {
        public String epnA;
        public String epnB;

        public JoinTx(String epnA, String epnB) {
            this.epnA = epnA;
            this.epnB = epnB;
        }

        private Connection createConnection(String epn, int end) throws NamingException, ResourceUnavailableException, TooManyConnectionsException {
            Endpoint endpoint = EndpointQuery.lookup((String)epn);
            return endpoint.createConnection(MsLinkImpl.this.getMode(end));
        }

        private void execute() {
            try {
                ((MsLinkImpl)MsLinkImpl.this).connections[0] = this.createConnection(this.epnA, 0);
                ((MsLinkImpl)MsLinkImpl.this).endpoints[0] = MsLinkImpl.this.connections[0].getEndpoint().getLocalName();
                MsLinkImpl.this.logger.debug((Object)("Created local connection: " + MsLinkImpl.this.connections[0].getId()));
            }
            catch (NamingException e) {
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.ENDPOINT_UNKNOWN, e.getMessage());
                return;
            }
            catch (ResourceUnavailableException e) {
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.RESOURCE_UNAVAILABLE, e.getMessage());
                return;
            }
            catch (TooManyConnectionsException e) {
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.FACILITY_FAILURE, e.getMessage());
                return;
            }
            try {
                ((MsLinkImpl)MsLinkImpl.this).connections[1] = this.createConnection(this.epnB, 1);
                ((MsLinkImpl)MsLinkImpl.this).endpoints[1] = MsLinkImpl.this.connections[1].getEndpoint().getLocalName();
                MsLinkImpl.this.logger.debug((Object)("Created local connection: " + MsLinkImpl.this.connections[1].getId()));
            }
            catch (NamingException e) {
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.ENDPOINT_UNKNOWN, e.getMessage());
                return;
            }
            catch (ResourceUnavailableException e) {
                MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.RESOURCE_UNAVAILABLE, e.getMessage());
                return;
            }
            catch (TooManyConnectionsException e) {
                MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
                MsLinkImpl.this.logger.warn((Object)"TX Failed", (Throwable)e);
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.FACILITY_FAILURE, e.getMessage());
                return;
            }
            try {
                MsLinkImpl.this.connections[0].setOtherParty(MsLinkImpl.this.connections[1]);
                MsLinkImpl.this.connections[1].setOtherParty(MsLinkImpl.this.connections[0]);
                MsLinkImpl.this.logger.debug((Object)("Join connections [" + MsLinkImpl.this.connections[0].getId() + "," + MsLinkImpl.this.connections[0].getId()));
                MsLinkImpl.this.state = MsLinkState.JOINED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_JOINED, MsLinkEventCause.NORMAL, null);
            }
            catch (IOException e) {
                MsLinkImpl.this.logger.error((Object)"Could not join connections", (Throwable)e);
                MsLinkImpl.this.connections[1].getEndpoint().deleteConnection(MsLinkImpl.this.connections[1].getId());
                MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
                MsLinkImpl.this.state = MsLinkState.FAILED;
                MsLinkImpl.this.sendEvent(MsLinkEventID.LINK_FAILED, MsLinkEventCause.FACILITY_FAILURE, e.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NDC.push((String)("JOIN TX ID = " + MsLinkImpl.this.id));
            try {
                this.execute();
            }
            finally {
                NDC.pop();
                NDC.remove();
            }
        }
    }
}

