/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.media.msc.common.MsLinkMode;
import org.mobicents.media.msc.common.MsSessionState;
import org.mobicents.media.msc.common.events.MsSessionEventCause;
import org.mobicents.media.msc.common.events.MsSessionEventID;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.impl.MsConnectionImpl;
import org.mobicents.mscontrol.impl.MsLinkImpl;
import org.mobicents.mscontrol.impl.MsSessionEventImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSessionImpl
implements MsSession {
    private static final long serialVersionUID = 1376371530688007623L;
    private String id = new UID().toString();
    protected MsProvider provider;
    protected ArrayList<MsSessionListener> listeners = new ArrayList();
    private ArrayList<MsLink> links = new ArrayList();
    private ArrayList<MsConnection> connections = new ArrayList();
    private MsSessionState state;

    public MsSessionImpl(MsProvider provider) {
        this.provider = provider;
        this.listeners.addAll(provider.getSessionListeners());
    }

    public String getId() {
        return this.id;
    }

    public MsProvider getProvider() {
        return this.provider;
    }

    public MsSessionState getState() {
        return this.state;
    }

    public synchronized MsLink createLink(MsLinkMode mode) {
        MsLinkImpl link = new MsLinkImpl(this, mode);
        this.links.add(link);
        this.setState(MsSessionState.ACTIVE, MsSessionEventCause.LINK_CREATED, link);
        link.fireMsLinkCreated();
        return link;
    }

    public synchronized void disassociateLink(MsLink link) {
        this.links.remove(link);
        if (this.links.size() == 0 && this.connections.size() == 0) {
            this.setState(MsSessionState.INVALID, MsSessionEventCause.LINK_DROPPED, link);
        }
    }

    public synchronized MsConnection createNetworkConnection(String trunkName) {
        MsConnectionImpl connection = new MsConnectionImpl(this, trunkName);
        this.connections.add(connection);
        this.setState(MsSessionState.ACTIVE, MsSessionEventCause.CONNECTION_CREATED, connection);
        connection.fireConnectionInitialized();
        return connection;
    }

    public synchronized void disassociateNetworkConnection(MsConnection connection) {
        this.connections.remove(connection);
        if (this.links.size() == 0 && this.connections.size() == 0) {
            this.setState(MsSessionState.INVALID, MsSessionEventCause.CONNECTION_DROPPED, connection);
        }
    }

    public void setSessionStateIdle() {
        this.setState(MsSessionState.IDLE, MsSessionEventCause.SESSION_CREATED, this);
    }

    private void sendEvent(MsSessionEventID eventID, MsSessionEventCause eventCause, Object causeObject) {
        MsSessionEventImpl evt = new MsSessionEventImpl(this, eventID, eventCause, causeObject);
        new Thread(evt).start();
    }

    private void setState(MsSessionState state, MsSessionEventCause eventCause, Object causeObject) {
        if (this.state != state) {
            this.state = state;
            switch (state) {
                case IDLE: {
                    this.sendEvent(MsSessionEventID.SESSION_CREATED, eventCause, causeObject);
                    break;
                }
                case ACTIVE: {
                    this.sendEvent(MsSessionEventID.SESSION_ACTIVE, eventCause, causeObject);
                    break;
                }
                case INVALID: {
                    this.sendEvent(MsSessionEventID.SESSION_INVALID, eventCause, causeObject);
                }
            }
        }
    }

    public void addSessionListener(MsSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSessionListener(MsSessionListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return "MsSessionImpl[" + this.id + "]";
    }

    public List<MsSessionListener> getSessionListeners() {
        return this.listeners;
    }

    public List<MsConnection> getConnections() {
        return this.connections;
    }
}

