/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingException;
import javax.sdp.SdpException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.mobicents.media.msc.common.MsConnectionState;
import org.mobicents.media.msc.common.events.MsConnectionEventCause;
import org.mobicents.media.msc.common.events.MsConnectionEventID;
import org.mobicents.media.server.impl.common.ConnectionMode;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.impl.MsConnectionEventImpl;

public class MsConnectionImpl
implements MsConnection {
    private transient Logger logger = Logger.getLogger(MsConnectionImpl.class);
    private String id = new UID().toString();
    private MsConnectionState state;
    private String remoteSdp;
    private MsSession session;
    private String endpointName;
    protected Connection connection;
    private Endpoint endpoint;
    protected ArrayList<MsConnectionListener> listeners = new ArrayList();

    public MsConnectionImpl(MsSession session, String endpointName) {
        this.session = session;
        this.endpointName = endpointName;
        this.listeners.addAll(session.getProvider().getConnectionListeners());
    }

    public String getId() {
        return this.id;
    }

    public MsSession getSession() {
        return this.session;
    }

    public String getLocalDescriptor() {
        return this.connection != null ? this.connection.getLocalDescriptor() : null;
    }

    public String getRemoteDescriptor() {
        return this.connection != null ? this.connection.getRemoteDescriptor() : null;
    }

    public String getEndpoint() {
        return this.endpoint != null ? this.endpoint.getLocalName() : null;
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.listeners.remove(listener);
    }

    public Collection getConnectionListeners() {
        return this.listeners;
    }

    public void modify(String localDesc, String remoteDesc) {
        this.remoteSdp = remoteDesc;
        Runnable tx = this.endpoint == null ? new CreateTx(this) : new ModifyTx(this);
        new Thread(tx).start();
    }

    public void release() {
        if (this.endpoint != null) {
            DeleteTx tx = new DeleteTx();
            new Thread(tx).start();
        }
        this.session.disassociateNetworkConnection((MsConnection)this);
    }

    public void fireConnectionInitialized() {
        this.setState(MsConnectionState.IDLE);
        this.sendEvent(MsConnectionEventID.CONNECTION_INITIALIZED, MsConnectionEventCause.NORMAL, null);
    }

    private synchronized void sendEvent(MsConnectionEventID eventID, MsConnectionEventCause cause, String msg) {
        MsConnectionEventImpl evt = new MsConnectionEventImpl(this, eventID, cause, msg);
        new Thread(evt).start();
    }

    public MsConnectionState getState() {
        return this.state;
    }

    private void setState(MsConnectionState state) {
        this.state = state;
    }

    public String toString() {
        return this.id;
    }

    private class DeleteTx
    implements Runnable {
        private DeleteTx() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NDC.push((String)("DELETE TX = " + MsConnectionImpl.this.id));
            try {
                if (MsConnectionImpl.this.connection != null) {
                    if (MsConnectionImpl.this.logger.isDebugEnabled()) {
                        MsConnectionImpl.this.logger.debug((Object)("Deleting connection " + this));
                    }
                    MsConnectionImpl.this.endpoint.deleteConnection(MsConnectionImpl.this.connection.getId());
                    MsConnectionImpl.this.setState(MsConnectionState.CLOSED);
                    MsConnectionImpl.this.sendEvent(MsConnectionEventID.CONNECTION_DELETED, MsConnectionEventCause.NORMAL, null);
                }
            }
            finally {
                NDC.pop();
                NDC.remove();
            }
        }
    }

    private class ModifyTx
    implements Runnable {
        private MsConnectionImpl localConnection;

        public ModifyTx(MsConnectionImpl localConnection) {
            this.localConnection = localConnection;
        }

        private void execute() {
            if (MsConnectionImpl.this.remoteSdp != null) {
                try {
                    MsConnectionImpl.this.connection.setRemoteDescriptor(MsConnectionImpl.this.remoteSdp);
                    MsConnectionImpl.this.logger.debug((Object)"Updated remote descriptor");
                }
                catch (SdpException ex) {
                    MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                    MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.REMOTE_SDP_INVALID, ex.getMessage());
                }
                catch (IOException ex) {
                    MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                    MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.FACILITY_FAILURE, ex.getMessage());
                }
            }
            MsConnectionImpl.this.setState(MsConnectionState.OPEN);
            MsConnectionImpl.this.sendEvent(MsConnectionEventID.CONNECTION_MODIFIED, MsConnectionEventCause.NORMAL, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NDC.push((String)("MODIFY TX ID = " + MsConnectionImpl.this.id));
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                this.execute();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                NDC.pop();
                NDC.remove();
            }
        }
    }

    private class CreateTx
    implements Runnable {
        private MsConnectionImpl localConnection;

        public CreateTx(MsConnectionImpl localConnection) {
            this.localConnection = localConnection;
        }

        private void execute() {
            try {
                MsConnectionImpl.this.endpoint = EndpointQuery.lookup((String)MsConnectionImpl.this.endpointName);
                MsConnectionImpl.this.endpointName = MsConnectionImpl.this.endpoint.getLocalName();
                MsConnectionImpl.this.logger.debug((Object)("Media server returns endpoint: " + MsConnectionImpl.this.endpoint.getLocalName()));
            }
            catch (NamingException ex) {
                MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.ENDPOINT_UNKNOWN, ex.getMessage());
                return;
            }
            catch (ResourceUnavailableException ex) {
                MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.RESOURCE_UNAVAILABLE, ex.getMessage());
                return;
            }
            try {
                MsConnectionImpl.this.connection = MsConnectionImpl.this.endpoint.createConnection(ConnectionMode.SEND_RECV);
                MsConnectionImpl.this.setState(MsConnectionState.HALF_OPEN);
                MsConnectionImpl.this.logger.debug((Object)("Media server creates connection : id = " + MsConnectionImpl.this.connection.getId()));
            }
            catch (TooManyConnectionsException ex) {
                MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.FACILITY_FAILURE, ex.getMessage());
                return;
            }
            catch (ResourceUnavailableException ex) {
                MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.RESOURCE_UNAVAILABLE, ex.getMessage());
                return;
            }
            if (MsConnectionImpl.this.remoteSdp != null) {
                try {
                    MsConnectionImpl.this.connection.setRemoteDescriptor(MsConnectionImpl.this.remoteSdp);
                    MsConnectionImpl.this.logger.debug((Object)"Updated remote descriptor");
                }
                catch (SdpException ex) {
                    MsConnectionImpl.this.endpoint.deleteConnection(MsConnectionImpl.this.connection.getId());
                    MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                    MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.REMOTE_SDP_INVALID, ex.getMessage());
                    return;
                }
                catch (IOException ex) {
                    MsConnectionImpl.this.endpoint.deleteConnection(MsConnectionImpl.this.connection.getId());
                    MsConnectionImpl.this.logger.warn((Object)"TX Failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED);
                    MsConnectionImpl.this.sendEvent(MsConnectionEventID.TX_FAILED, MsConnectionEventCause.FACILITY_FAILURE, ex.getMessage());
                    return;
                }
            }
            MsConnectionImpl.this.setState(MsConnectionState.OPEN);
            MsConnectionImpl.this.sendEvent(MsConnectionEventID.CONNECTION_CREATED, MsConnectionEventCause.NORMAL, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            NDC.push((String)("CREATE TX ID = " + MsConnectionImpl.this.id));
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                this.execute();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                NDC.pop();
                NDC.remove();
            }
        }
    }
}

