/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.mscontrol.MsCallbackHandler;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.MsSignalDetector;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.mscontrol.impl.MsSessionImpl;
import org.mobicents.mscontrol.impl.MsSignalDetectorImpl;
import org.mobicents.mscontrol.impl.MsSignalGeneratorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsProviderImpl
implements MsProvider,
Serializable {
    private static final long serialVersionUID = -2166483960453025777L;
    protected ArrayList<MsSessionListener> sessionListeners = new ArrayList();
    protected ArrayList<MsConnectionListener> connectionListeners = new ArrayList();
    protected ArrayList<MsResourceListener> resourceListeners = new ArrayList();
    protected ArrayList<MsLinkListener> linkListeners = new ArrayList();
    private ArrayList<MsSession> calls = new ArrayList();
    private MsCallbackHandler callbackHandler = null;

    public MsSession createSession() {
        MsSessionImpl call = new MsSessionImpl(this);
        this.calls.add(call);
        if (this.callbackHandler != null) {
            this.callbackHandler.handle((Object)call);
        }
        call.setSessionStateIdle();
        return call;
    }

    public void addSessionListener(MsSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(MsSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public List<MsSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }

    public void addResourceListener(MsResourceListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.resourceListeners.remove(listener);
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public List<MsConnectionListener> getConnectionListeners() {
        return this.connectionListeners;
    }

    public void addLinkListener(MsLinkListener listener) {
        this.linkListeners.add(listener);
    }

    public void removeLinkListener(MsLinkListener listener) {
        this.linkListeners.remove(listener);
    }

    public MsSignalGenerator getSignalGenerator(String endpointName) {
        MsSignalGeneratorImpl msSignalGenerator = new MsSignalGeneratorImpl(this, endpointName);
        if (this.callbackHandler != null) {
            this.callbackHandler.handle((Object)msSignalGenerator);
        }
        return msSignalGenerator;
    }

    public MsSignalDetector getSignalDetector(String endpointName) {
        MsSignalDetectorImpl signalDetectror = new MsSignalDetectorImpl(this, endpointName);
        if (this.callbackHandler != null) {
            this.callbackHandler.handle((Object)signalDetectror);
        }
        return signalDetectror;
    }

    public MsConnection getMsConnection(String msConnectionId) {
        for (MsSession e : this.calls) {
            for (MsConnection c : e.getConnections()) {
                if (!c.getId().equals(msConnectionId)) continue;
                return c;
            }
        }
        return null;
    }

    public List<MsConnection> getMsConnections(String endpointName) {
        ArrayList<MsConnection> msConnectionList = new ArrayList<MsConnection>();
        for (MsSession e : this.calls) {
            for (MsConnection c : e.getConnections()) {
                if (!c.getEndpoint().equals(endpointName)) continue;
                msConnectionList.add(c);
            }
        }
        return msConnectionList;
    }

    public List<MsResourceListener> getResourceListeners() {
        return this.resourceListeners;
    }

    public List<MsLinkListener> getLinkListeners() {
        return this.linkListeners;
    }

    public MsCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(MsCallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }
}

