/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.mobicents.media.server.impl.common.events.EventCause;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.UnknownSignalException;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.mscontrol.impl.MsNotifyEventImpl;

public class MsSignalGeneratorImpl
implements MsSignalGenerator,
NotificationListener {
    private Endpoint endpoint;
    private String endpointName;
    private MsProvider provider;
    private String id = new UID().toString();
    private ArrayList<MsResourceListener> listeners = new ArrayList();
    private boolean released = false;

    public MsSignalGeneratorImpl(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MsSignalGeneratorImpl(MsProvider provider, String endpointName) {
        this.provider = provider;
        this.endpointName = endpointName;
        this.listeners.addAll(provider.getResourceListeners());
    }

    public String getID() {
        return this.id;
    }

    public void setResourceStateIdle() {
        MsNotifyEventImpl evt = new MsNotifyEventImpl((MsResource)this, EventID.DTMF, EventCause.NORMAL, "Created new MsSignalGenerator");
        for (MsResourceListener listener : this.listeners) {
            listener.resourceCreated((MsNotifyEvent)evt);
        }
    }

    public void apply(EventID signalID, String[] params) {
        new Thread(new PlayTx(this, signalID, params)).start();
    }

    public void update(NotifyEvent event) {
        if (!this.released) {
            MsNotifyEventImpl evt = new MsNotifyEventImpl((MsResource)this, event.getID(), event.getCause(), event.getMessage());
            this.sendEvent(evt);
        }
    }

    private void sendEvent(MsNotifyEvent evt) {
        for (MsResourceListener listener : this.listeners) {
            listener.update(evt);
        }
    }

    public void addResourceListener(MsResourceListener listener) {
        this.listeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.listeners.remove(listener);
    }

    public void release() {
        this.released = true;
        MsNotifyEventImpl evt = new MsNotifyEventImpl((MsResource)this, EventID.INVALID, EventCause.NORMAL, "Inavlidated MsSignalGenerator");
        for (MsResourceListener listener : this.listeners) {
            listener.resourceInvalid((MsNotifyEvent)evt);
        }
    }

    public String toString() {
        return "SignalGenerator[" + this.id + "]";
    }

    private class PlayTx
    implements Runnable {
        private EventID signalID;
        private String[] params;
        private MsSignalGeneratorImpl generator;

        public PlayTx(MsSignalGeneratorImpl generator, EventID signalID, String[] params) {
            this.generator = generator;
            this.signalID = signalID;
            this.params = params;
        }

        public void run() {
            MsNotifyEventImpl error;
            if (MsSignalGeneratorImpl.this.endpoint == null) {
                try {
                    MsSignalGeneratorImpl.this.endpoint = EndpointQuery.find((String)MsSignalGeneratorImpl.this.endpointName);
                }
                catch (NamingException ex) {
                    error = new MsNotifyEventImpl((MsResource)this.generator, EventID.FAIL, EventCause.FACILITY_FAILURE, ex.getMessage());
                    MsSignalGeneratorImpl.this.sendEvent(error);
                }
                catch (ResourceUnavailableException ex) {
                    error = new MsNotifyEventImpl((MsResource)this.generator, EventID.FAIL, EventCause.FACILITY_FAILURE, ex.getMessage());
                    MsSignalGeneratorImpl.this.sendEvent(error);
                }
            }
            try {
                MsSignalGeneratorImpl.this.endpoint.play(this.signalID, this.params, null, (NotificationListener)this.generator, false, false);
            }
            catch (UnknownSignalException ex) {
                error = new MsNotifyEventImpl((MsResource)this.generator, EventID.FAIL, EventCause.FACILITY_FAILURE, ex.getMessage());
                MsSignalGeneratorImpl.this.sendEvent(error);
            }
        }
    }
}

