/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsConnectionEventCause;
import org.mobicents.mscontrol.MsConnectionEventID;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.impl.MsConnectionImpl;

public class MsConnectionEventImpl
implements MsConnectionEvent,
Runnable {
    private MsConnectionImpl connection;
    private MsConnectionEventID eventID;
    private MsConnectionEventCause cause;
    private String msg;

    public MsConnectionEventImpl(MsConnectionImpl connection, MsConnectionEventID eventID, MsConnectionEventCause cause, String msg) {
        this.connection = connection;
        this.eventID = eventID;
        this.cause = cause;
        this.msg = msg;
    }

    public MsConnection getConnection() {
        return this.connection;
    }

    public MsConnectionEventID getEventID() {
        return this.eventID;
    }

    public MsConnectionEventCause getCause() {
        return this.cause;
    }

    public String getMessage() {
        return this.msg;
    }

    public void run() {
        for (MsConnectionListener listener : this.connection.session.provider.connectionListeners) {
            switch (this.eventID) {
                case CONNECTION_CREATED: {
                    listener.connectionCreated((MsConnectionEvent)this);
                    break;
                }
                case CONNECTION_HALF_OPEN: {
                    listener.connectionHalfOpen((MsConnectionEvent)this);
                    break;
                }
                case CONNECTION_OPEN: {
                    listener.connectionOpen((MsConnectionEvent)this);
                    break;
                }
                case CONNECTION_FAILED: {
                    listener.connectionFailed((MsConnectionEvent)this);
                    break;
                }
                case CONNECTION_DISCONNECTED: {
                    listener.connectionDisconnected((MsConnectionEvent)this);
                }
            }
        }
    }
}

