/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import javax.naming.NamingException;
import javax.sdp.SdpException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEventCause;
import org.mobicents.mscontrol.MsConnectionEventID;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsConnectionState;
import org.mobicents.mscontrol.MsEndpoint;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.impl.MsConnectionEventImpl;
import org.mobicents.mscontrol.impl.MsEndpointImpl;
import org.mobicents.mscontrol.impl.MsProviderImpl;
import org.mobicents.mscontrol.impl.MsSessionImpl;
import org.mobicents.mscontrol.impl.events.EventParser;

public class MsConnectionImpl
implements MsConnection,
ConnectionListener,
NotificationListener {
    private String id = new UID().toString();
    private MsConnectionState state;
    private String remoteSdp;
    protected MsSessionImpl session;
    private String endpointName;
    protected Connection connection;
    private MsEndpointImpl endpoint;
    protected ArrayList<MsNotificationListener> eventListeners = new ArrayList();
    private transient Logger logger = Logger.getLogger(MsConnectionImpl.class);
    private EventParser eventParser = new EventParser();

    public MsConnectionImpl(MsSessionImpl session, String endpointName) {
        this.session = session;
        this.endpointName = endpointName;
        this.setState(MsConnectionState.IDLE, MsConnectionEventCause.NORMAL);
    }

    public String getId() {
        return this.id;
    }

    public MsSession getSession() {
        return this.session;
    }

    public String getLocalDescriptor() {
        return this.connection != null ? this.connection.getLocalDescriptor() : null;
    }

    public String getRemoteDescriptor() {
        return this.connection != null ? this.connection.getRemoteDescriptor() : null;
    }

    public MsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.session.provider.connectionListeners.add(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.session.provider.connectionListeners.remove(listener);
    }

    public void modify(String localDesc, String remoteDesc) {
        this.remoteSdp = remoteDesc;
        Runnable tx = this.endpoint == null ? new CreateTx(this) : new ModifyTx(this);
        MsProviderImpl.submit(tx);
    }

    public void release() {
        if (this.endpoint != null) {
            DeleteTx tx = new DeleteTx();
            MsProviderImpl.submit(tx);
        }
    }

    private synchronized void sendEvent(MsConnectionEventID eventID, MsConnectionEventCause cause, String msg) {
        MsConnectionEventImpl evt = new MsConnectionEventImpl(this, eventID, cause, msg);
        MsProviderImpl.sendEvent(evt);
    }

    public MsConnectionState getState() {
        return this.state;
    }

    private void setState(MsConnectionState state, MsConnectionEventCause cause) {
        this.state = state;
        switch (state) {
            case IDLE: {
                this.sendEvent(MsConnectionEventID.CONNECTION_CREATED, cause, null);
                break;
            }
            case HALF_OPEN: {
                this.sendEvent(MsConnectionEventID.CONNECTION_HALF_OPEN, cause, null);
                break;
            }
            case OPEN: {
                this.sendEvent(MsConnectionEventID.CONNECTION_OPEN, cause, null);
                break;
            }
            case FAILED: {
                this.sendEvent(MsConnectionEventID.CONNECTION_FAILED, cause, null);
                this.setState(MsConnectionState.CLOSED, cause);
                break;
            }
            case CLOSED: {
                this.session.removeConnection(this);
                this.sendEvent(MsConnectionEventID.CONNECTION_DISCONNECTED, cause, null);
            }
        }
    }

    public String toString() {
        return this.id;
    }

    public void update(NotifyEvent event) {
        System.out.println("MsConnection: receive event");
        MsNotifyEvent evt = this.eventParser.parse(this, event);
        for (MsNotificationListener listener : this.session.provider.eventListeners) {
            System.out.println("MsConnectio nSending event to " + listener);
            listener.update(evt);
        }
    }

    public void onStateChange(Connection connection, ConnectionState oldState) {
        if (this.connection != connection) {
            return;
        }
        switch (connection.getState()) {
            case NULL: {
                this.setState(MsConnectionState.IDLE, MsConnectionEventCause.NORMAL);
                break;
            }
            case HALF_OPEN: {
                this.setState(MsConnectionState.HALF_OPEN, MsConnectionEventCause.NORMAL);
                break;
            }
            case OPEN: {
                this.setState(MsConnectionState.OPEN, MsConnectionEventCause.NORMAL);
                break;
            }
            case CLOSED: {
                this.setState(MsConnectionState.CLOSED, MsConnectionEventCause.NORMAL);
            }
        }
    }

    private class DeleteTx
    implements Runnable {
        private DeleteTx() {
        }

        public void run() {
            if (MsConnectionImpl.this.connection != null) {
                ((MsConnectionImpl)MsConnectionImpl.this).endpoint.server.deleteConnection(MsConnectionImpl.this.connection.getId());
            }
        }
    }

    private class ModifyTx
    implements Runnable {
        private MsConnectionImpl localConnection;

        public ModifyTx(MsConnectionImpl localConnection) {
            this.localConnection = localConnection;
        }

        public void run() {
            if (MsConnectionImpl.this.remoteSdp != null) {
                try {
                    MsConnectionImpl.this.connection.setRemoteDescriptor(MsConnectionImpl.this.remoteSdp);
                }
                catch (SdpException ex) {
                    MsConnectionImpl.this.logger.error((Object)"Setting remote SDP failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.REMOTE_SDP_INVALID);
                }
                catch (IOException ex) {
                    MsConnectionImpl.this.logger.error((Object)"Setting remote SDP failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.FACILITY_FAILURE);
                }
                catch (ResourceUnavailableException ex) {
                    MsConnectionImpl.this.logger.error((Object)"Setting remote SDP failed", (Throwable)ex);
                    MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.REMOTE_SDP_INVALID);
                }
            }
        }
    }

    private class CreateTx
    implements Runnable {
        private MsConnectionImpl localConnection;

        public CreateTx(MsConnectionImpl localConnection) {
            this.localConnection = localConnection;
        }

        public void run() {
            try {
                MsConnectionImpl.this.endpoint = new MsEndpointImpl(EndpointQuery.lookup((String)MsConnectionImpl.this.endpointName), MsConnectionImpl.this.session.getProvider());
                MsConnectionImpl.this.endpointName = ((MsConnectionImpl)MsConnectionImpl.this).endpoint.server.getLocalName();
                MsConnectionImpl.this.logger.debug((Object)("Media server returns endpoint: " + ((MsConnectionImpl)MsConnectionImpl.this).endpoint.server.getLocalName()));
                ((MsConnectionImpl)MsConnectionImpl.this).endpoint.server.addConnectionListener((ConnectionListener)this.localConnection);
                MsConnectionImpl.this.connection = ((MsConnectionImpl)MsConnectionImpl.this).endpoint.server.createConnection(ConnectionMode.SEND_RECV);
                MsConnectionImpl.this.setState(MsConnectionState.HALF_OPEN, MsConnectionEventCause.NORMAL);
                if (MsConnectionImpl.this.remoteSdp != null) {
                    MsConnectionImpl.this.connection.setRemoteDescriptor(MsConnectionImpl.this.remoteSdp);
                }
            }
            catch (NamingException e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.ENDPOINT_UNKNOWN);
            }
            catch (ResourceUnavailableException e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.FACILITY_FAILURE);
            }
            catch (TooManyConnectionsException e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.FACILITY_FAILURE);
            }
            catch (SdpException e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.REMOTE_SDP_INVALID);
            }
            catch (IOException e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.FACILITY_FAILURE);
            }
            catch (Exception e) {
                MsConnectionImpl.this.logger.error((Object)("Creation of Connection failed for Endpoint " + MsConnectionImpl.this.endpointName), (Throwable)e);
                MsConnectionImpl.this.setState(MsConnectionState.FAILED, MsConnectionEventCause.FACILITY_FAILURE);
            }
        }
    }
}

