/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.events.RequestedEvent;
import org.mobicents.media.server.spi.events.RequestedSignal;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsEndpoint;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.impl.MsConnectionImpl;
import org.mobicents.mscontrol.impl.MsLinkImpl;
import org.mobicents.mscontrol.impl.MsProviderImpl;
import org.mobicents.mscontrol.impl.events.BaseRequestedEvent;
import org.mobicents.mscontrol.impl.events.BaseRequestedSignal;

public class MsEndpointImpl
implements MsEndpoint {
    protected Endpoint server;
    private MsProvider msprovider;

    protected MsEndpointImpl(Endpoint endpoint, MsProvider msProvider) {
        this.server = endpoint;
        this.msprovider = msProvider;
    }

    public String getLocalName() {
        return this.server.getLocalName();
    }

    protected Endpoint getEndpoint() {
        return this.server;
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.msprovider.addConnectionListener(listener);
    }

    public void addNotificationListener(MsNotificationListener listener) {
        this.msprovider.addNotificationListener(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.msprovider.removeConnectionListener(listener);
    }

    public void removeNotificationListener(MsNotificationListener listener) {
        this.msprovider.removeNotificationListener(listener);
    }

    public void execute(MsRequestedSignal[] signals, MsRequestedEvent[] events) {
        MsProviderImpl.submit(new Tx(signals, events, null, null));
    }

    public void execute(MsRequestedSignal[] signals, MsRequestedEvent[] events, MsConnection connection) {
        String connectionID = ((MsConnectionImpl)connection).connection.getId();
        MsProviderImpl.submit(new Tx(signals, events, connectionID, (MsConnectionImpl)connection));
    }

    public void execute(MsRequestedSignal[] signals, MsRequestedEvent[] events, MsLink link) {
        String connectionID = ((MsLinkImpl)link).getConnectionID(this.getLocalName());
        MsProviderImpl.submit(new Tx(signals, events, connectionID, (MsLinkImpl)link));
    }

    private class Tx
    implements Runnable {
        private MsRequestedSignal[] signals;
        private MsRequestedEvent[] events;
        private String connectionID;
        private NotificationListener listener;

        protected Tx(MsRequestedSignal[] signals, MsRequestedEvent[] events, String connectionID, NotificationListener listener) {
            this.events = events;
            this.signals = signals;
            this.connectionID = connectionID;
            this.listener = listener;
        }

        public void run() {
            RequestedSignal[] s = new RequestedSignal[this.signals.length];
            for (int i = 0; i < this.signals.length; ++i) {
                s[i] = ((BaseRequestedSignal)this.signals[i]).convert();
            }
            RequestedEvent[] evt = new RequestedEvent[this.events.length];
            for (int i = 0; i < this.events.length; ++i) {
                evt[i] = ((BaseRequestedEvent)this.events[i]).convert();
                evt[i].setHandler(this.listener);
            }
            MsEndpointImpl.this.server.execute(s, evt, this.connectionID);
        }
    }
}

