/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.MsSignalDetector;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.mscontrol.impl.MsEventFactoryImpl;
import org.mobicents.mscontrol.impl.MsSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsProviderImpl
implements MsProvider,
Serializable {
    private static Logger logger = Logger.getLogger(MsProviderImpl.class);
    private static final long serialVersionUID = -2166483960453025777L;
    protected ArrayList<MsSessionListener> sessionListeners = new ArrayList();
    protected ArrayList<MsConnectionListener> connectionListeners = new ArrayList();
    protected ArrayList<MsResourceListener> resourceListeners = new ArrayList();
    protected ArrayList<MsLinkListener> linkListeners = new ArrayList();
    protected ArrayList<MsNotificationListener> eventListeners = new ArrayList();
    protected ArrayList<MsSession> sessions = new ArrayList();
    protected static ExecutorService pool = Executors.newFixedThreadPool(5, new ThreadFactoryImpl());
    private static QueuedExecutor eventQueue = new QueuedExecutor();

    public MsSession createSession() {
        MsSessionImpl call = new MsSessionImpl(this);
        this.sessions.add(call);
        return call;
    }

    public MsEventFactory getEventFactory() {
        return new MsEventFactoryImpl();
    }

    public void addSessionListener(MsSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(MsSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public void addResourceListener(MsResourceListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.resourceListeners.remove(listener);
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void addLinkListener(MsLinkListener listener) {
        this.linkListeners.add(listener);
    }

    public void removeLinkListener(MsLinkListener listener) {
        this.linkListeners.remove(listener);
    }

    public void addNotificationListener(MsNotificationListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeNotificationListener(MsNotificationListener listener) {
        this.eventListeners.remove(listener);
    }

    public MsSignalGenerator getSignalGenerator(String endpointName) {
        return null;
    }

    public MsSignalDetector getSignalDetector(String endpointName) {
        return null;
    }

    public MsConnection getMsConnection(String msConnectionId) {
        for (MsSession e : this.sessions) {
            for (MsConnection c : e.getConnections()) {
                if (!c.getId().equals(msConnectionId)) continue;
                return c;
            }
        }
        return null;
    }

    public List<MsConnection> getMsConnections(String endpointName) {
        ArrayList<MsConnection> msConnectionList = new ArrayList<MsConnection>();
        for (MsSession e : this.sessions) {
            for (MsConnection c : e.getConnections()) {
                if (!c.getEndpoint().getLocalName().equals(endpointName)) continue;
                msConnectionList.add(c);
            }
        }
        return msConnectionList;
    }

    protected static synchronized void submit(Runnable task) {
        pool.submit(task);
    }

    protected static synchronized void sendEvent(Runnable event) {
        try {
            eventQueue.execute(event);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Firing of event failed " + event), (Throwable)e);
        }
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        static final AtomicInteger msProviderPoolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "MsProviderImpl-FixedThreadPool-" + msProviderPoolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

