/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl.events;

import java.io.Serializable;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.media.server.spi.events.dtmf.DtmfEvent;
import org.mobicents.media.server.spi.events.pkg.DTMF;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.events.MsEventIdentifier;
import org.mobicents.mscontrol.impl.MsNotifyEventImpl;
import org.mobicents.mscontrol.impl.events.dtmf.DtmfNotifyEventImpl;

public class EventParser
implements Serializable {
    public MsNotifyEvent parse(Object source, NotifyEvent evt) {
        if (evt.getEventID().equals(DTMF.DTMF)) {
            DtmfEvent event = (DtmfEvent)evt;
            return new DtmfNotifyEventImpl(source, event.getSequence());
        }
        String packageName = evt.getEventID().getPackageName();
        String eventName = evt.getEventID().getEventName();
        return new MsNotifyEventImpl(source, new EventID(packageName, eventName));
    }

    private class EventID
    implements MsEventIdentifier {
        private String packageName;
        private String eventName;

        protected EventID(String packageName, String eventName) {
            this.packageName = packageName;
            this.eventName = eventName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getFqn() {
            return this.packageName + "." + this.eventName;
        }
    }
}

