/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionState;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.TooManyConnectionsException;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.mscontrol.MsEndpoint;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEventCause;
import org.mobicents.mscontrol.MsLinkEventID;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsLinkMode;
import org.mobicents.mscontrol.MsLinkState;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.impl.MsEndpointImpl;
import org.mobicents.mscontrol.impl.MsLinkEventImpl;
import org.mobicents.mscontrol.impl.MsProviderImpl;
import org.mobicents.mscontrol.impl.MsSessionImpl;
import org.mobicents.mscontrol.impl.PendingQueue;
import org.mobicents.mscontrol.impl.events.EventParser;

public class MsLinkImpl
implements MsLink,
ConnectionListener,
NotificationListener {
    private static final long serialVersionUID = 6373269860176309745L;
    protected Logger logger = Logger.getLogger(this.getClass());
    private final String id = new UID().toString();
    protected MsSessionImpl session;
    private MsLinkMode mode;
    private MsLinkState state;
    private Connection[] connections = new Connection[2];
    private MsEndpointImpl[] endpoints = new MsEndpointImpl[2];
    private EventParser eventParser = new EventParser();
    private int permits = 0;
    private PendingQueue[] pendingQueue = new PendingQueue[2];
    protected CopyOnWriteArrayList<MsLinkListener> linkLocalLinkListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsNotificationListener> linkLocalNotificationListeners = new CopyOnWriteArrayList();

    public String getId() {
        return this.id;
    }

    public MsLinkImpl(MsSessionImpl session, MsLinkMode mode) {
        this.session = session;
        this.mode = mode;
        this.setState(MsLinkState.IDLE, MsLinkEventCause.NORMAL);
    }

    public MsSession getSession() {
        return this.session;
    }

    public MsLinkState getState() {
        return this.state;
    }

    private void setState(MsLinkState state, MsLinkEventCause cause) {
        this.state = state;
        switch (state) {
            case IDLE: {
                this.sendEvent(MsLinkEventID.LINK_CREATED, cause, null);
                break;
            }
            case CONNECTED: {
                this.sendEvent(MsLinkEventID.LINK_CONNECTED, cause, null);
                break;
            }
            case FAILED: {
                this.sendEvent(MsLinkEventID.LINK_FAILED, cause, null);
                break;
            }
            case DISCONNECTED: {
                this.session.removeLink(this);
                this.sendEvent(MsLinkEventID.LINK_DISCONNECTED, cause, null);
            }
        }
    }

    protected String getConnectionID(String endpointName) {
        if (this.endpoints != null) {
            if (this.endpoints[0].server.getLocalName().matches(endpointName)) {
                return this.connections[0].getId();
            }
            if (this.endpoints[1].server.getLocalName().matches(endpointName)) {
                return this.connections[1].getId();
            }
        }
        return null;
    }

    private void sendEvent(MsLinkEventID eventID, MsLinkEventCause cause, String msg) {
        MsLinkEventImpl evt = new MsLinkEventImpl(this, eventID, cause, msg);
        MsProviderImpl.sendEvent(evt);
    }

    public void join(String a, String b) {
        JoinTx tx = new JoinTx(this, a, b);
        MsProviderImpl.submit(tx);
    }

    public MsEndpoint[] getEndpoints() {
        return this.endpoints;
    }

    public void addLinkListener(MsLinkListener listener) {
        this.linkLocalLinkListeners.add(listener);
    }

    public void removeLinkListener(MsLinkListener listener) {
        this.linkLocalLinkListeners.remove(listener);
    }

    public void addNotificationListener(MsNotificationListener listener) {
        this.linkLocalNotificationListeners.add(listener);
    }

    public void removeNotificationListener(MsNotificationListener listener) {
        this.linkLocalNotificationListeners.remove(listener);
    }

    public void release() {
        DropTx tx = new DropTx();
        MsProviderImpl.submit(tx);
    }

    private PendingQueue getQueue(String endpointName) {
        if (this.endpoints[0].getLocalName().equals(endpointName)) {
            return this.pendingQueue[0];
        }
        return this.pendingQueue[1];
    }

    public void append(MsRequestedSignal requestedSignal, String endpointName) {
        this.getQueue(endpointName).append(requestedSignal);
    }

    public void append(MsRequestedEvent requestedEvent, String endpointName) {
        this.getQueue(endpointName).append(requestedEvent);
    }

    public String toString() {
        return this.id;
    }

    private boolean isSevered() {
        if (this.connections[0] != null && this.connections[1] != null) {
            return this.connections[0].getState() == ConnectionState.CLOSED && this.connections[1].getState() == ConnectionState.CLOSED;
        }
        return this.connections[0] != null ? this.connections[0].getState() == ConnectionState.CLOSED : this.connections[1].getState() == ConnectionState.CLOSED;
    }

    private ConnectionMode getMode(int end) {
        switch (this.mode) {
            case FULL_DUPLEX: {
                return ConnectionMode.SEND_RECV;
            }
            case HALF_DUPLEX: {
                return end == 0 ? ConnectionMode.SEND_ONLY : ConnectionMode.RECV_ONLY;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStateChange(Connection connection, ConnectionState oldState) {
        switch (this.state) {
            case IDLE: {
                switch (connection.getState()) {
                    case OPEN: {
                        ++this.permits;
                        if (this.permits != 2) break;
                        this.setState(MsLinkState.CONNECTED, MsLinkEventCause.NORMAL);
                        return;
                    }
                    case CLOSED: {
                        if (!this.isSevered()) break;
                        this.setState(MsLinkState.DISCONNECTED, MsLinkEventCause.NORMAL);
                    }
                }
                return;
            }
            case CONNECTED: {
                switch (connection.getState()) {
                    case CLOSED: 
                    case HALF_OPEN: {
                        --this.permits;
                        if (this.permits != 0) return;
                        this.setState(MsLinkState.DISCONNECTED, MsLinkEventCause.NORMAL);
                    }
                }
            }
        }
    }

    public void update(NotifyEvent event) {
        MsNotifyEvent evt = this.eventParser.parse(this, event);
        for (MsNotificationListener listener : this.session.provider.eventListeners) {
            listener.update(evt);
        }
        for (MsNotificationListener listener : this.linkLocalNotificationListeners) {
            listener.update(evt);
        }
    }

    private class DropTx
    implements Runnable {
        private DropTx() {
        }

        public void run() {
            try {
                if (MsLinkImpl.this.connections[1] != null) {
                    MsLinkImpl.this.connections[1].getEndpoint().deleteConnection(MsLinkImpl.this.connections[1].getId());
                }
            }
            catch (Exception e) {
                MsLinkImpl.this.logger.info((Object)"Error on connection remove, index: 1", (Throwable)e);
            }
            try {
                if (MsLinkImpl.this.connections[0] != null) {
                    MsLinkImpl.this.connections[0].getEndpoint().deleteConnection(MsLinkImpl.this.connections[0].getId());
                }
            }
            catch (Exception e) {
                MsLinkImpl.this.logger.info((Object)"Error on connection remove, index: 0", (Throwable)e);
            }
        }
    }

    private class JoinTx
    implements Runnable {
        public String epnA;
        public String epnB;
        private MsLinkImpl link;

        public JoinTx(MsLinkImpl link, String epnA, String epnB) {
            this.link = link;
            this.epnA = epnA;
            this.epnB = epnB;
        }

        private Connection createConnection(String epn, int end) throws NamingException, ResourceUnavailableException, TooManyConnectionsException {
            Endpoint endpoint = EndpointQuery.lookup((String)epn);
            return endpoint.createLocalConnection(MsLinkImpl.this.getMode(end));
        }

        public void run() {
            try {
                ((MsLinkImpl)MsLinkImpl.this).connections[0] = this.createConnection(this.epnA, 0);
                MsLinkImpl.this.connections[0].addListener((ConnectionListener)this.link);
                ((MsLinkImpl)MsLinkImpl.this).endpoints[0] = new MsEndpointImpl(MsLinkImpl.this.connections[0].getEndpoint(), MsLinkImpl.this.session.getProvider());
                ((MsLinkImpl)MsLinkImpl.this).pendingQueue[0] = new PendingQueue(MsLinkImpl.this.connections[0].getEndpoint(), MsLinkImpl.this.connections[0].getId());
                ((MsLinkImpl)MsLinkImpl.this).connections[1] = this.createConnection(this.epnB, 1);
                MsLinkImpl.this.connections[1].addListener((ConnectionListener)this.link);
                ((MsLinkImpl)MsLinkImpl.this).endpoints[1] = new MsEndpointImpl(MsLinkImpl.this.connections[1].getEndpoint(), MsLinkImpl.this.session.getProvider());
                ((MsLinkImpl)MsLinkImpl.this).pendingQueue[1] = new PendingQueue(MsLinkImpl.this.connections[1].getEndpoint(), MsLinkImpl.this.connections[1].getId());
                MsLinkImpl.this.connections[0].setOtherParty(MsLinkImpl.this.connections[1]);
            }
            catch (NamingException e) {
                MsLinkImpl.this.logger.error((Object)"Joining of endpoint for Link failed", (Throwable)e);
                MsLinkImpl.this.setState(MsLinkState.FAILED, MsLinkEventCause.ENDPOINT_UNKNOWN);
            }
            catch (ResourceUnavailableException e) {
                MsLinkImpl.this.logger.error((Object)"Joining of endpoint for Link failed", (Throwable)e);
                MsLinkImpl.this.setState(MsLinkState.FAILED, MsLinkEventCause.RESOURCE_UNAVAILABLE);
            }
            catch (TooManyConnectionsException e) {
                MsLinkImpl.this.logger.error((Object)"Joining of endpoint for Link failed", (Throwable)e);
                MsLinkImpl.this.setState(MsLinkState.FAILED, MsLinkEventCause.RESOURCE_UNAVAILABLE);
            }
            catch (Exception e) {
                MsLinkImpl.this.logger.error((Object)"Joining of endpoint for Link failed", (Throwable)e);
                MsLinkImpl.this.setState(MsLinkState.FAILED, MsLinkEventCause.FACILITY_FAILURE);
            }
        }
    }
}

