/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkMode;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionEventCause;
import org.mobicents.mscontrol.MsSessionEventID;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.MsSessionState;
import org.mobicents.mscontrol.impl.MsConnectionImpl;
import org.mobicents.mscontrol.impl.MsLinkImpl;
import org.mobicents.mscontrol.impl.MsProviderImpl;
import org.mobicents.mscontrol.impl.MsSessionEventImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSessionImpl
implements MsSession {
    private static final long serialVersionUID = 1376371530688007623L;
    private String id = new UID().toString();
    protected MsProviderImpl provider;
    protected ArrayList<MsLink> links = new ArrayList();
    protected ArrayList<MsConnection> connections = new ArrayList();
    private MsSessionState state;

    public MsSessionImpl(MsProviderImpl provider) {
        this.provider = provider;
        this.setState(MsSessionState.IDLE, MsSessionEventCause.SESSION_CREATED, this);
    }

    public String getId() {
        return this.id;
    }

    public MsProvider getProvider() {
        return this.provider;
    }

    public MsSessionState getState() {
        return this.state;
    }

    public synchronized MsLink createLink(MsLinkMode mode) {
        MsLinkImpl link = new MsLinkImpl(this, mode);
        this.links.add(link);
        this.setState(MsSessionState.ACTIVE, MsSessionEventCause.LINK_CREATED, link);
        return link;
    }

    public synchronized MsConnection createNetworkConnection(String trunkName) {
        MsConnectionImpl connection = new MsConnectionImpl(this, trunkName);
        this.connections.add(connection);
        this.setState(MsSessionState.ACTIVE, MsSessionEventCause.CONNECTION_CREATED, connection);
        return connection;
    }

    private void sendEvent(MsSessionEventID eventID, MsSessionEventCause eventCause, Object causeObject) {
        MsSessionEventImpl evt = new MsSessionEventImpl(this, eventID, eventCause, causeObject);
        MsProviderImpl.sendEvent(evt);
    }

    private void setState(MsSessionState state, MsSessionEventCause eventCause, Object causeObject) {
        if (this.state != state) {
            this.state = state;
            switch (state) {
                case IDLE: {
                    this.sendEvent(MsSessionEventID.SESSION_CREATED, eventCause, causeObject);
                    break;
                }
                case ACTIVE: {
                    this.sendEvent(MsSessionEventID.SESSION_ACTIVE, eventCause, causeObject);
                    break;
                }
                case INVALID: {
                    this.provider.sessions.remove(this);
                    this.sendEvent(MsSessionEventID.SESSION_INVALID, eventCause, causeObject);
                }
            }
        }
    }

    public void addSessionListener(MsSessionListener listener) {
        this.provider.sessionListeners.add(listener);
    }

    public void removeSessionListener(MsSessionListener listener) {
        this.provider.sessionListeners.remove(listener);
    }

    public List<MsConnection> getConnections() {
        return this.connections;
    }

    protected void removeConnection(MsConnection msConnection) {
        this.connections.remove(msConnection);
        if (this.connections.isEmpty() && this.links.isEmpty()) {
            this.setState(MsSessionState.INVALID, MsSessionEventCause.CONNECTION_DROPPED, null);
        }
    }

    protected void removeLink(MsLink link) {
        this.links.remove(link);
        if (this.connections.isEmpty() && this.links.isEmpty()) {
            this.setState(MsSessionState.INVALID, MsSessionEventCause.CONNECTION_DROPPED, null);
        }
    }

    public String toString() {
        return this.id;
    }
}

