/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSignalDetector;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.events.dtmf.MsDtmfRequestedEvent;
import org.mobicents.mscontrol.events.pkg.DTMF;
import org.mobicents.mscontrol.impl.MsConnectionImpl;
import org.mobicents.mscontrol.impl.MsProviderImpl;

public class MsSignalDetectorImpl
implements MsSignalDetector,
NotificationListener {
    private Endpoint endpoint;
    private String endpointName;
    private MsProviderImpl provider;
    private String id = new UID().toString();
    private ArrayList<MsResourceListener> listeners = new ArrayList();
    private transient Logger logger = Logger.getLogger(MsSignalDetectorImpl.class);

    public MsSignalDetectorImpl(MsProviderImpl provider, String endpointName) {
        this.provider = provider;
        this.endpointName = endpointName;
    }

    public String getID() {
        return this.id;
    }

    private void detectDTMF() {
        try {
            MsEventFactory factory = this.provider.getEventFactory();
            MsDtmfRequestedEvent dtmf = (MsDtmfRequestedEvent)factory.createRequestedEvent(DTMF.TONE);
            MsRequestedSignal[] signals = new MsRequestedSignal[]{};
            MsRequestedEvent[] events = new MsRequestedEvent[]{dtmf};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void release() {
    }

    public void setResourceStateIdle() {
    }

    public void receive(EventID signalID, boolean persistent) {
        new Thread(new SubscribeTx(this, signalID, persistent)).start();
    }

    public void receive(EventID signalID, MsConnection connection, String[] params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Subscribe eventID=" + signalID + ", connection=" + connection));
        }
        new Thread(new SubscribeTx1(this, signalID, connection, params)).start();
    }

    public void update(NotifyEvent event) {
    }

    public void addResourceListener(MsResourceListener listener) {
        this.listeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.listeners.remove(listener);
    }

    private class SubscribeTx1
    implements Runnable {
        private EventID signalID;
        private boolean persistent;
        private NotificationListener listener;
        private String[] params;
        private MsConnection connection;

        public SubscribeTx1(NotificationListener listener, EventID signalID, MsConnection connection, String[] params) {
            this.listener = listener;
            this.signalID = signalID;
            this.connection = connection;
            this.params = params;
        }

        public void run() {
            try {
                MsSignalDetectorImpl.this.endpoint = EndpointQuery.find((String)MsSignalDetectorImpl.this.endpointName);
                MsConnectionImpl con = (MsConnectionImpl)this.connection;
                String connectionID = con.connection.getId();
                if (MsSignalDetectorImpl.this.logger.isDebugEnabled()) {
                    MsSignalDetectorImpl.this.logger.debug((Object)("Subscribe signalID =" + this.signalID + ", endpoint=" + MsSignalDetectorImpl.this.endpoint));
                }
            }
            catch (Exception e) {
                MsSignalDetectorImpl.this.logger.error((Object)"Subscribing to MsSignalDetector failed with error ", (Throwable)e);
            }
        }
    }

    private class SubscribeTx
    implements Runnable {
        private EventID signalID;
        private boolean persistent;
        private NotificationListener listener;

        public SubscribeTx(NotificationListener listener, EventID signalID, boolean persistent) {
            this.listener = listener;
            this.signalID = signalID;
            this.persistent = persistent;
        }

        public void run() {
        }
    }
}

