/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.EndpointQuery;
import org.mobicents.media.server.spi.NotificationListener;
import org.mobicents.media.server.spi.ResourceUnavailableException;
import org.mobicents.media.server.spi.events.NotifyEvent;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.mscontrol.events.MsEventAction;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.events.ann.MsPlayRequestedSignal;
import org.mobicents.mscontrol.events.pkg.MsAnnouncement;
import org.mobicents.mscontrol.impl.MsConnectionImpl;
import org.mobicents.mscontrol.impl.MsLinkImpl;

public class MsSignalGeneratorImpl
implements MsSignalGenerator,
NotificationListener {
    private Endpoint endpoint;
    private String endpointName;
    private MsProvider provider;
    private String id = new UID().toString();
    private ArrayList<MsResourceListener> listeners = new ArrayList();
    private boolean released = false;

    public MsSignalGeneratorImpl(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MsSignalGeneratorImpl(MsProvider provider, String endpointName) {
        this.provider = provider;
        this.endpointName = endpointName;
    }

    public String getID() {
        return this.id;
    }

    public void setResourceStateIdle() {
    }

    public void apply(EventID signalID, String[] params) {
        switch (signalID) {
            default: 
        }
        new Thread(new PlayTx(this, signalID, params)).start();
    }

    public void apply(EventID signalID, MsConnection connection, String[] params) {
        String conID = ((MsConnectionImpl)connection).connection.getId();
        new Thread(new PlayTx1(this, signalID, conID, params)).start();
    }

    public void apply(EventID signalID, MsLink link, String[] params) {
        switch (signalID) {
            case PLAY: {
                this.doPlay(params[0], (MsLinkImpl)link);
            }
        }
    }

    public void update(NotifyEvent event) {
    }

    private void sendEvent(MsNotifyEvent evt) {
        for (MsResourceListener listener : this.listeners) {
            listener.update(evt);
        }
    }

    public void addResourceListener(MsResourceListener listener) {
        this.listeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.listeners.remove(listener);
    }

    public void release() {
        this.released = true;
    }

    private void doPlay(String url, MsLinkImpl link) {
        MsEventFactory eventFactory = this.provider.getEventFactory();
        MsPlayRequestedSignal play = (MsPlayRequestedSignal)eventFactory.createRequestedSignal(MsAnnouncement.PLAY);
        play.setURL(url);
        link.append((MsRequestedSignal)play, this.endpointName);
        MsRequestedEvent onCompleted = eventFactory.createRequestedEvent(MsAnnouncement.COMPLETED);
        onCompleted.setEventAction(MsEventAction.NOTIFY);
        link.append(onCompleted, this.endpointName);
        MsRequestedEvent onFailed = eventFactory.createRequestedEvent(MsAnnouncement.FAILED);
        onFailed.setEventAction(MsEventAction.NOTIFY);
        link.append(onFailed, this.endpointName);
    }

    private void doRecord() {
    }

    public String toString() {
        return "SignalGenerator[" + this.id + "]";
    }

    private class PlayTx1
    implements Runnable {
        private EventID signalID;
        private String[] params;
        private MsSignalGeneratorImpl generator;
        private String connID;

        public PlayTx1(MsSignalGeneratorImpl generator, EventID signalID, String connID, String[] params) {
            this.generator = generator;
            this.signalID = signalID;
            this.params = params;
            this.connID = connID;
        }

        public void run() {
            if (MsSignalGeneratorImpl.this.endpoint == null) {
                try {
                    MsSignalGeneratorImpl.this.endpoint = EndpointQuery.find((String)MsSignalGeneratorImpl.this.endpointName);
                }
                catch (NamingException ex) {
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    // empty catch block
                }
            }
            if (this.params.length > 1) {
                // empty if block
            }
        }
    }

    private class PlayTx
    implements Runnable {
        private EventID signalID;
        private String[] params;
        private MsSignalGeneratorImpl generator;

        public PlayTx(MsSignalGeneratorImpl generator, EventID signalID, String[] params) {
            this.generator = generator;
            this.signalID = signalID;
            this.params = params;
        }

        public void run() {
            block3: {
                if (MsSignalGeneratorImpl.this.endpoint != null) break block3;
                try {
                    MsSignalGeneratorImpl.this.endpoint = EndpointQuery.find((String)MsSignalGeneratorImpl.this.endpointName);
                }
                catch (NamingException ex) {
                }
                catch (ResourceUnavailableException resourceUnavailableException) {}
            }
        }
    }
}

