/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.mobicents.media.server.spi.Endpoint;
import org.mobicents.media.server.spi.events.RequestedEvent;
import org.mobicents.media.server.spi.events.RequestedSignal;
import org.mobicents.mscontrol.events.MsRequestedEvent;
import org.mobicents.mscontrol.events.MsRequestedSignal;
import org.mobicents.mscontrol.impl.events.BaseRequestedEvent;
import org.mobicents.mscontrol.impl.events.BaseRequestedSignal;

public class PendingQueue
implements Serializable {
    private static final long serialVersionUID = -3919993537673967279L;
    private static final int DELAY = 500;
    private Timer timer = new Timer();
    private TimerTask sender;
    private boolean timerStarted;
    private ArrayList<MsRequestedSignal> requestedSignals = new ArrayList();
    private ArrayList<MsRequestedEvent> requestedEvents = new ArrayList();
    private Endpoint endpoint;
    private String connectionID;
    private ReentrantLock state = new ReentrantLock();

    protected PendingQueue(Endpoint endpoint, String connectionID) {
        this.endpoint = endpoint;
        this.connectionID = connectionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(MsRequestedSignal requestedSignal) {
        this.state.lock();
        try {
            if (this.requestedSignals.isEmpty() && !this.timerStarted) {
                this.startTimer();
            }
            this.requestedSignals.add(requestedSignal);
        }
        finally {
            this.state.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(MsRequestedEvent requestedEvent) {
        this.state.lock();
        try {
            if (this.requestedEvents.isEmpty() && !this.timerStarted) {
                this.startTimer();
            }
            this.requestedEvents.add(requestedEvent);
        }
        finally {
            this.state.unlock();
        }
    }

    private void startTimer() {
        this.sender = new Sender();
        this.timer.schedule(this.sender, 500L);
        this.timerStarted = true;
    }

    private class Sender
    extends TimerTask {
        private Sender() {
        }

        public void run() {
            RequestedSignal[] s = new RequestedSignal[PendingQueue.this.requestedSignals.size()];
            int i = 0;
            for (MsRequestedSignal rs : PendingQueue.this.requestedSignals) {
                s[i++] = ((BaseRequestedSignal)rs).convert();
            }
            PendingQueue.this.requestedSignals.clear();
            RequestedEvent[] e = new RequestedEvent[PendingQueue.this.requestedEvents.size()];
            i = 0;
            for (MsRequestedEvent re : PendingQueue.this.requestedEvents) {
                e[i++] = ((BaseRequestedEvent)re).convert();
            }
            PendingQueue.this.requestedEvents.clear();
            PendingQueue.this.endpoint.execute(s, e, PendingQueue.this.connectionID);
            PendingQueue.this.timer.purge();
        }
    }
}

