/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionListener;
import org.mobicents.mscontrol.MsEndpoint;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.MsNotificationListener;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResourceListener;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSessionListener;
import org.mobicents.mscontrol.events.MsEventFactory;
import org.mobicents.mscontrol.impl.MsEventFactoryImpl;
import org.mobicents.mscontrol.impl.MsSessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsProviderImpl
implements MsProvider,
Serializable {
    private static transient Logger logger = Logger.getLogger(MsProviderImpl.class);
    private static final long serialVersionUID = -2166483960453025777L;
    protected CopyOnWriteArrayList<MsSessionListener> sessionListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsConnectionListener> connectionListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsResourceListener> resourceListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsLinkListener> linkListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsNotificationListener> eventListeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<MsSession> sessions = new CopyOnWriteArrayList();
    protected static transient ExecutorService pool = Executors.newFixedThreadPool(10, new ThreadFactoryImpl());
    private transient CopyOnWriteArrayList<ExecutorService> queues = new CopyOnWriteArrayList();
    private transient EventQueueThreadFactory threadFactory = new EventQueueThreadFactory();

    public MsProviderImpl() {
        for (int i = 0; i < 10; ++i) {
            this.queues.add(Executors.newSingleThreadExecutor(this.threadFactory));
        }
    }

    public synchronized MsSession createSession() {
        MsSessionImpl session = new MsSessionImpl(this, this.allocateQueue());
        this.sessions.add(session);
        return session;
    }

    public MsEventFactory getEventFactory() {
        return new MsEventFactoryImpl();
    }

    private ExecutorService allocateQueue() {
        if (!this.queues.isEmpty()) {
            return this.queues.remove(0);
        }
        return Executors.newSingleThreadExecutor(this.threadFactory);
    }

    protected void deallocateQueue(ExecutorService queue) {
        this.queues.add(queue);
    }

    public void addSessionListener(MsSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(MsSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public void addResourceListener(MsResourceListener listener) {
        this.resourceListeners.add(listener);
    }

    public void removeResourceListener(MsResourceListener listener) {
        this.resourceListeners.remove(listener);
    }

    public void addConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(MsConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void addLinkListener(MsLinkListener listener) {
        this.linkListeners.add(listener);
    }

    public void removeLinkListener(MsLinkListener listener) {
        this.linkListeners.remove(listener);
    }

    public void addNotificationListener(MsNotificationListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeNotificationListener(MsNotificationListener listener) {
        this.eventListeners.remove(listener);
    }

    public MsConnection getMsConnection(String msConnectionId) {
        for (MsSession e : this.sessions) {
            for (MsConnection c : e.getConnections()) {
                if (!c.getId().equals(msConnectionId)) continue;
                return c;
            }
        }
        return null;
    }

    public List<MsConnection> getMsConnections(String endpointName) {
        ArrayList<MsConnection> msConnectionList = new ArrayList<MsConnection>();
        for (MsSession e : this.sessions) {
            for (MsConnection c : e.getConnections()) {
                MsEndpoint endpoint = c.getEndpoint();
                if (endpoint == null || !endpoint.getLocalName().equals(endpointName)) continue;
                msConnectionList.add(c);
            }
        }
        return msConnectionList;
    }

    public List<MsLink> getMsLinks(String endpointName) {
        ArrayList<MsLink> msLinkList = new ArrayList<MsLink>();
        for (MsSession e : this.sessions) {
            for (MsLink c : e.getLinks()) {
                MsEndpoint[] endpoint = c.getEndpoints();
                if ((endpoint[0] == null || !endpoint[0].getLocalName().equals(endpointName)) && (endpoint[1] == null || !endpoint[1].getLocalName().equals(endpointName))) continue;
                msLinkList.add(c);
            }
        }
        return msLinkList;
    }

    protected static void submit(Runnable task) {
        pool.submit(task);
    }

    private class EventQueueThreadFactory
    implements ThreadFactory {
        private EventQueueThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "MsSessionEventQueue");
            return t;
        }
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        static final AtomicInteger msProviderPoolNumber = new AtomicInteger(1);
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "MsProviderImpl-FixedThreadPool-" + msProviderPoolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

