/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mscontrol.impl;

import java.util.Collection;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsLinkEventCause;
import org.mobicents.mscontrol.MsLinkEventID;
import org.mobicents.mscontrol.MsLinkListener;
import org.mobicents.mscontrol.impl.MsLinkImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsLinkEventImpl
implements MsLinkEvent,
Runnable {
    private static final long serialVersionUID = -3952630702449890912L;
    private MsLinkImpl source;
    private MsLinkEventID eventID;
    private MsLinkEventCause cause;
    private String msg;

    public MsLinkEventImpl(MsLinkImpl source, MsLinkEventID eventID, MsLinkEventCause cause) {
        this.source = source;
        this.eventID = eventID;
        this.cause = cause;
    }

    public MsLinkEventImpl(MsLinkImpl source, MsLinkEventID eventID, MsLinkEventCause cause, String msg) {
        this.source = source;
        this.eventID = eventID;
        this.cause = cause;
        this.msg = msg;
    }

    public MsLink getSource() {
        return this.source;
    }

    public MsLinkEventID getEventID() {
        return this.eventID;
    }

    public MsLinkEventCause getCause() {
        return this.cause;
    }

    public String getMessage() {
        return this.msg;
    }

    private void update(Collection<MsLinkListener> listeners) {
        for (MsLinkListener listener : listeners) {
            switch (this.eventID) {
                case LINK_CREATED: {
                    listener.linkCreated((MsLinkEvent)this);
                    break;
                }
                case LINK_CONNECTED: {
                    listener.linkConnected((MsLinkEvent)this);
                    break;
                }
                case LINK_DISCONNECTED: {
                    listener.linkDisconnected((MsLinkEvent)this);
                    break;
                }
                case LINK_FAILED: {
                    listener.linkFailed((MsLinkEvent)this);
                    break;
                }
                case MODE_HALF_DUPLEX: {
                    listener.modeHalfDuplex((MsLinkEvent)this);
                    break;
                }
                case MODE_FULL_DUPLEX: {
                    listener.modeFullDuplex((MsLinkEvent)this);
                }
            }
        }
    }

    @Override
    public void run() {
        this.update(this.source.session.provider.linkListeners);
        this.update(this.source.linkLocalLinkListeners);
    }
}

