/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.subscription.data;

import java.io.Serializable;

public class SubscriptionKey
implements Serializable {
    private static final long serialVersionUID = -6638892043798746768L;
    public static final String NO_DIALOG_ID = "_";
    private final String dialogId;
    private final String eventPackage;
    private final String eventId;
    private transient Boolean internalSubscription;
    private transient Boolean wInfoSubscription;
    private transient String toString = null;
    private static final String WINFO = ".winfo";

    public SubscriptionKey(String dialogId, String eventPackage, String eventId) {
        if (dialogId == null) {
            throw new NullPointerException("null dialog id");
        }
        this.dialogId = dialogId;
        this.eventPackage = eventPackage;
        this.eventId = eventId;
    }

    public String getDialogId() {
        return this.dialogId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventPackage() {
        return this.eventPackage;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dialogId == null ? 0 : this.dialogId.hashCode());
        result = 31 * result + (this.eventId == null ? 0 : this.eventId.hashCode());
        result = 31 * result + (this.eventPackage == null ? 0 : this.eventPackage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionKey other = (SubscriptionKey)obj;
        if (this.dialogId == null ? other.dialogId != null : !this.dialogId.equals(other.dialogId)) {
            return false;
        }
        if (this.eventId == null ? other.eventId != null : !this.eventId.equals(other.eventId)) {
            return false;
        }
        return !(this.eventPackage == null ? other.eventPackage != null : !this.eventPackage.equals(other.eventPackage));
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "SubscriptionKeydialogId=" + this.dialogId + ",eventPackage=" + this.eventPackage + ",eventId=" + String.valueOf(this.eventId);
        }
        return this.toString;
    }

    public boolean isInternalSubscription() {
        if (this.internalSubscription == null) {
            this.internalSubscription = this.dialogId.equals(NO_DIALOG_ID);
        }
        return this.internalSubscription;
    }

    public boolean isWInfoSubscription() {
        if (this.wInfoSubscription == null) {
            this.wInfoSubscription = this.eventPackage.endsWith(WINFO);
        }
        return this.wInfoSubscription;
    }
}

