/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorContext;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddress;
import org.mobicents.slee.xdm.server.ServerConfiguration;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStepByAttr;
import org.openxdm.xcap.common.uri.NodeSelector;
import org.openxdm.xcap.common.uri.Parser;
import org.openxdm.xcap.common.uri.ResourceSelector;

public class ListReferenceEndpointAddressParser {
    private final Tracer tracer;

    public ListReferenceEndpointAddressParser(ResourceAdaptorContext context) {
        this.tracer = context.getTracer(this.getClass().getSimpleName());
    }

    public String getLocalXcapRoot() {
        return ServerConfiguration.getInstance().getXcapRoot();
    }

    public String getSchemeAndAuthorityURI() {
        return ServerConfiguration.getInstance().getSchemeAndAuthority();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ListReferenceEndpointAddress getAddress(String uri, boolean absoluteURI) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Making address from resource list uri " + uri);
        }
        try {
            block11: {
                if (absoluteURI) {
                    String shemeAndAuthorityURI = this.getSchemeAndAuthorityURI();
                    if (uri.startsWith(shemeAndAuthorityURI)) {
                        uri = uri.substring(shemeAndAuthorityURI.length());
                        break block11;
                    } else {
                        if (this.tracer.isFineEnabled()) {
                            this.tracer.fine("The resource list (to dereference) uri " + uri + " does not starts with server scheme and authority uri " + shemeAndAuthorityURI);
                        }
                        return null;
                    }
                }
                uri = "/" + uri;
            }
            ResourceSelector resourceSelector = null;
            int queryComponentSeparator = uri.indexOf(63);
            resourceSelector = queryComponentSeparator > 0 ? Parser.parseResourceSelector((String)this.getLocalXcapRoot(), (String)uri.substring(0, queryComponentSeparator), (String)uri.substring(queryComponentSeparator + 1)) : Parser.parseResourceSelector((String)this.getLocalXcapRoot(), (String)uri, null);
            DocumentSelector documentSelector = DocumentSelector.valueOf((String)resourceSelector.getDocumentSelector());
            if (!documentSelector.getAUID().equals("resource-lists")) {
                this.tracer.severe("Unable to make address, invalid or not supported resource list uri: " + uri);
                return null;
            }
            ElementSelector elementSelector = null;
            if (resourceSelector.getNodeSelector() != null) {
                NodeSelector nodeSelector = Parser.parseNodeSelector((String)resourceSelector.getNodeSelector(), null);
                elementSelector = Parser.parseElementSelector((String)nodeSelector.getElementSelector());
                if (elementSelector.getStepsSize() < 2) {
                    this.tracer.warning("List reference element selector selects resource-list root element. Uri: " + uri);
                    return null;
                }
                for (int i = 1; i < elementSelector.getStepsSize(); ++i) {
                    if (elementSelector.getStep(i) instanceof ElementSelectorStepByAttr) continue;
                    this.tracer.warning("List reference element selector includes steps not selected by attribute value, not supported, all references will become with BAD GATEWAY 502 state. Uri: " + uri);
                    return null;
                }
            }
            return new ListReferenceEndpointAddress(documentSelector, elementSelector);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to parse resource list (to dereference) " + uri, (Throwable)e);
            return null;
        }
    }
}

