/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddress;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceFrom;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceTo;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheResourceAdaptor;
import org.mobicents.slee.sipevent.server.rlscache.ResourceList;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesAddedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesRemovedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesUpdatedEvent;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.PackagesType;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ServiceType;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLSServiceImpl
implements RLSService,
ListReferenceFrom {
    private Set<EntryType> entries;
    private final ListReferenceEndpointAddress address;
    private final RLSServicesCacheResourceAdaptor ra;
    private ResourceList list;
    private ListReferenceTo reference;
    private boolean updating = false;
    private final String uri;
    private PackagesType packages;
    private RLSService.Status status = RLSService.Status.DOES_NOT_EXISTS;

    public RLSServiceImpl(String uri, ListReferenceEndpointAddress address, RLSServicesCacheResourceAdaptor ra) {
        this.uri = uri;
        this.address = address;
        this.ra = ra;
    }

    public String getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntryType> getEntries() {
        RLSServiceImpl rLSServiceImpl = this;
        synchronized (rLSServiceImpl) {
            RLSService.Status status = this.getStatus();
            if (status != RLSService.Status.OK) {
                throw new IllegalStateException("rls service is in state " + status);
            }
            if (this.entries == null) {
                this.entries = this.reference != null ? Collections.unmodifiableSet(this.reference.getEntries()) : Collections.unmodifiableSet(this.list.getEntries());
            }
            return this.entries;
        }
    }

    public PackagesType getPackages() {
        return this.packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServiceType(ServiceType serviceType) {
        RLSServiceImpl rLSServiceImpl = this;
        synchronized (rLSServiceImpl) {
            this.updating = true;
            RLSService.Status oldStatus = this.status;
            if (serviceType == null) {
                if (oldStatus != RLSService.Status.DOES_NOT_EXISTS) {
                    this.status = RLSService.Status.DOES_NOT_EXISTS;
                    Set<Object> oldEntries = this.entries;
                    if (oldEntries == null) {
                        oldEntries = Collections.emptySet();
                    }
                    RLSServicesRemovedEvent event = new RLSServicesRemovedEvent(this.uri, RLSService.Status.DOES_NOT_EXISTS, oldStatus, oldEntries);
                    this.entries = null;
                    this.ra.fireRLSServicesRemovedEvent(this.uri, event);
                }
            } else {
                Set<EntryType> oldEntries = this.entries;
                this.processServiceType(serviceType);
                this.processUpdate(oldStatus, oldEntries);
            }
            this.updating = false;
        }
    }

    private void processUpdate(RLSService.Status oldStatus, Set<EntryType> oldEntries) {
        RLSService.Status currentStatus = this.status;
        if (currentStatus == RLSService.Status.BAD_GATEWAY) {
            if (oldEntries == null) {
                oldEntries = Collections.emptySet();
            }
            RLSServicesRemovedEvent event = new RLSServicesRemovedEvent(this.uri, currentStatus, oldStatus, oldEntries);
            this.entries = null;
            this.ra.fireRLSServicesRemovedEvent(this.uri, event);
        } else if (currentStatus == RLSService.Status.OK) {
            if (oldStatus != RLSService.Status.OK) {
                RLSServicesAddedEvent event = new RLSServicesAddedEvent(this.uri);
                this.ra.fireRLSServicesAddedEvent(this.uri, event);
            }
            Set removedEntries = null;
            Set<EntryType> newEntries = null;
            if (oldEntries == null) {
                oldEntries = Collections.emptySet();
                removedEntries = Collections.emptySet();
                newEntries = this.getEntries();
            } else {
                removedEntries = new HashSet<EntryType>(oldEntries);
                oldEntries = new HashSet<EntryType>();
                newEntries = new HashSet<EntryType>();
                for (EntryType entryType : this.getEntries()) {
                    if (!removedEntries.remove(entryType)) {
                        newEntries.add(entryType);
                        continue;
                    }
                    oldEntries.add(entryType);
                }
            }
            if (removedEntries.isEmpty() && newEntries.isEmpty()) {
                return;
            }
            RLSServicesUpdatedEvent event = new RLSServicesUpdatedEvent(this.uri, currentStatus, oldStatus, oldEntries, removedEntries, newEntries);
            this.ra.fireRLSServicesUpdatedEvent(this.uri, event);
        }
    }

    private void processServiceType(ServiceType serviceType) {
        this.packages = serviceType.getPackages();
        ListType listType = serviceType.getList();
        if (listType != null) {
            this.reference = null;
            LinkedList<ElementSelectorStep> steps = this.copyListAddressElementSelectorSteps();
            steps.add(new ElementSelectorStep("list"));
            ElementSelector elementSelector = new ElementSelector(steps);
            ListReferenceEndpointAddress listAddress = new ListReferenceEndpointAddress(this.getAddress().getDocumentSelector(), elementSelector);
            this.list = new ResourceList(listAddress, this, this.ra);
            this.list.setListType(listType);
            this.status = this.list.getStatus();
        } else {
            this.list = null;
            String resourceListURI = serviceType.getResourceList().trim();
            ListReferenceEndpointAddress listAddress = this.ra.getAddressParser().getAddress(resourceListURI, true);
            if (listAddress != null) {
                this.reference = this.ra.addReference(this, listAddress);
            }
            this.status = this.reference == null ? RLSService.Status.BAD_GATEWAY : this.reference.getStatus();
        }
    }

    private LinkedList<ElementSelectorStep> copyListAddressElementSelectorSteps() {
        LinkedList<ElementSelectorStep> elementSelectorSteps = new LinkedList<ElementSelectorStep>();
        ListReferenceEndpointAddress listAddress = this.getAddress();
        ElementSelector listElementSelector = listAddress.getElementSelector();
        for (int j = 0; j < listElementSelector.getStepsSize(); ++j) {
            elementSelectorSteps.add(listElementSelector.getStep(j));
        }
        return elementSelectorSteps;
    }

    public RLSService.Status getStatus() {
        return this.status;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((RLSServiceImpl)obj).uri.equals(this.uri);
        }
        return false;
    }

    public String toString() {
        return "RLSService(uri=" + this.uri + ") = " + this.getEntries().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(ListReferenceTo reference) {
        RLSServiceImpl rLSServiceImpl = this;
        synchronized (rLSServiceImpl) {
            if (this.updating) {
                return;
            }
            RLSService.Status oldStatus = this.status;
            Set<EntryType> oldEntries = this.entries;
            this.status = reference.getStatus();
            this.entries = null;
            this.processUpdate(oldStatus, oldEntries);
        }
    }

    @Override
    public ListReferenceEndpointAddress getAddress() {
        return this.address;
    }
}

