/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.resource.ActivityHandle;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivityHandle;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivityImpl;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceImpl;
import org.mobicents.slee.sipevent.server.rlscache.ReferencedResourceLists;
import org.mobicents.slee.sipevent.server.rlscache.ResourceListActivityHandle;
import org.mobicents.slee.sipevent.server.rlscache.ResourceListActivityImpl;
import org.openxdm.xcap.common.uri.DocumentSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLSServicesCacheDataSource {
    private ConcurrentHashMap<RLSServiceActivityHandle, RLSServiceActivityImpl> rlsServicesActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<ResourceListActivityHandle, ResourceListActivityImpl> resourceListsActivities = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RLSServiceImpl> rlsServices = new ConcurrentHashMap();
    private ConcurrentHashMap<DocumentSelector, ReferencedResourceLists> resourceLists = new ConcurrentHashMap();
    private ConcurrentHashMap<DocumentSelector, Set<String>> rlsServicesDocs = new ConcurrentHashMap();

    public void removeActivity(ActivityHandle handle) {
        if (handle.getClass() == ResourceListActivityHandle.TYPE) {
            this.removeResourceListActivity((ResourceListActivityHandle)handle);
        } else {
            this.removeRLSServiceActivity((RLSServiceActivityHandle)handle);
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (handle.getClass() == ResourceListActivityHandle.TYPE) {
            return this.getResourceListActivity((ResourceListActivityHandle)handle);
        }
        return this.getRLSServiceActivity((RLSServiceActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (activity.getClass() == ResourceListActivityImpl.TYPE) {
            ResourceListActivityImpl activityImpl = (ResourceListActivityImpl)activity;
            ResourceListActivityHandle handle = new ResourceListActivityHandle(activityImpl.getDocumentSelector());
            return this.resourceListsActivities.containsKey(handle) ? handle : null;
        }
        RLSServiceActivityImpl activityImpl = (RLSServiceActivityImpl)activity;
        RLSServiceActivityHandle handle = new RLSServiceActivityHandle(activityImpl.getServiceURI());
        return this.rlsServicesActivities.containsKey(handle) ? handle : null;
    }

    public RLSServiceActivityImpl putIfAbsentRLSServiceActivity(RLSServiceActivityHandle handle, RLSServiceActivityImpl activity) {
        return this.rlsServicesActivities.putIfAbsent(handle, activity);
    }

    public RLSServiceActivityImpl getRLSServiceActivity(RLSServiceActivityHandle handle) {
        return this.rlsServicesActivities.get(handle);
    }

    public RLSServiceActivityImpl removeRLSServiceActivity(RLSServiceActivityHandle handle) {
        return this.rlsServicesActivities.remove(handle);
    }

    public ResourceListActivityImpl putIfAbsentResourceListActivity(ResourceListActivityHandle handle, ResourceListActivityImpl activity) {
        return this.resourceListsActivities.putIfAbsent(handle, activity);
    }

    public ResourceListActivityImpl getResourceListActivity(ResourceListActivityHandle handle) {
        return this.resourceListsActivities.get(handle);
    }

    public ResourceListActivityImpl removeResourceListActivity(ResourceListActivityHandle handle) {
        return this.resourceListsActivities.remove(handle);
    }

    public RLSServiceImpl putRLSServiceIfAbsent(String serviceURI, RLSServiceImpl rlsService) {
        return this.rlsServices.putIfAbsent(serviceURI, rlsService);
    }

    public RLSServiceImpl getRLSService(String serviceURI) {
        return this.rlsServices.get(serviceURI);
    }

    public RLSServiceImpl removeRLSService(String serviceURI) {
        return this.rlsServices.remove(serviceURI);
    }

    public ReferencedResourceLists putResourceListIfAbsent(DocumentSelector documentSelector, ReferencedResourceLists resourceList) {
        return this.resourceLists.putIfAbsent(documentSelector, resourceList);
    }

    public ReferencedResourceLists getResourceList(DocumentSelector documentSelector) {
        return this.resourceLists.get(documentSelector);
    }

    public ReferencedResourceLists removeResourceList(DocumentSelector documentSelector) {
        return this.resourceLists.remove(documentSelector);
    }

    public void putRlsServicesDocs(DocumentSelector documentSelector, Set<String> rlsServicesDoc) {
        this.rlsServicesDocs.put(documentSelector, rlsServicesDoc);
    }

    public Set<String> getRlsServicesDocs(DocumentSelector documentSelector) {
        return this.rlsServicesDocs.get(documentSelector);
    }

    public Set<String> removeRlsServicesDocs(DocumentSelector documentSelector) {
        return this.rlsServicesDocs.remove(documentSelector);
    }

    public Set<String> getRLSServices() {
        return new HashSet<String>(this.rlsServices.keySet());
    }

    public Set<ActivityHandle> getAllHandles() {
        HashSet<ActivityHandle> result = new HashSet<ActivityHandle>(this.rlsServicesActivities.keySet());
        result.addAll(this.resourceListsActivities.keySet());
        return result;
    }
}

