/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sipevent.server.rlscache;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.slee.Address;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddress;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceEndpointAddressParser;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceFrom;
import org.mobicents.slee.sipevent.server.rlscache.ListReferenceTo;
import org.mobicents.slee.sipevent.server.rlscache.RLSService;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivity;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivityHandle;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceActivityImpl;
import org.mobicents.slee.sipevent.server.rlscache.RLSServiceImpl;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheDataSource;
import org.mobicents.slee.sipevent.server.rlscache.RLSServicesCacheSbbInterface;
import org.mobicents.slee.sipevent.server.rlscache.ReferencedResourceLists;
import org.mobicents.slee.sipevent.server.rlscache.ResourceListActivityHandle;
import org.mobicents.slee.sipevent.server.rlscache.ResourceListActivityImpl;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesAddedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesRemovedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.RLSServicesUpdatedEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.WatchRLSServicesEvent;
import org.mobicents.slee.sipevent.server.rlscache.events.WatchResourceListsEvent;
import org.mobicents.slee.sipevent.server.subscription.jmx.SubscriptionControlManagement;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ResourceLists;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.RlsServices;
import org.openxdm.xcap.client.appusage.rlsservices.jaxb.ServiceType;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStep;
import org.openxdm.xcap.common.uri.ElementSelectorStepByAttr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RLSServicesCacheResourceAdaptor
implements ResourceAdaptor,
RLSServicesCacheSbbInterface {
    private RLSServicesCacheDataSource dataSource;
    private Tracer tracer;
    private FireableEventType watchRLSServicesEvent;
    private FireableEventType watchResourceListsEvent;
    private FireableEventType rLSServicesAddedEvent;
    private FireableEventType rLSServicesRemovedEvent;
    private FireableEventType rLSServicesUpdatedEvent;
    private final ServiceID serviceID = new ServiceID("RLSServicesWatcherService", "org.mobicents", "1.0");
    private SleeEndpoint sleeEndpoint;
    private static final int ACTIVITY_FLAGS = ActivityFlags.setRequestSleeActivityGCCallback((int)2);
    private final RLSServiceActivityImpl dummyRLSServicesDocActivity = new RLSServiceActivityImpl("", this);
    private final RLSServiceActivityHandle dummyRLSServicesDocActivityHandle = new RLSServiceActivityHandle(this.dummyRLSServicesDocActivity.getServiceURI());
    private final DocumentSelector globalRLSServicesDocumentSelector = new DocumentSelector("rls-services/global", "index");
    private LinkedList<ElementSelectorStep> rlsServicesBaseElementSelectorSteps = this.initRlsServicesBaseElementSelectorSteps();
    private boolean serviceActive = false;
    private boolean raActive = false;
    private ListReferenceEndpointAddressParser addressParser;
    private ExecutorService executorService;
    public static JAXBContext jaxbContext = RLSServicesCacheResourceAdaptor.initJAxbContext();

    public RLSServicesCacheDataSource getDataSource() {
        return this.dataSource;
    }

    private LinkedList<ElementSelectorStep> initRlsServicesBaseElementSelectorSteps() {
        LinkedList<ElementSelectorStep> list = new LinkedList<ElementSelectorStep>();
        list.add(new ElementSelectorStep("rls-services"));
        return list;
    }

    private static JAXBContext initJAxbContext() {
        try {
            return JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.rlsservices.jaxb:org.openxdm.xcap.client.appusage.resourcelists.jaxb");
        }
        catch (JAXBException e) {
            throw new RuntimeException("unable to create jaxb context for pres rules docs", e);
        }
    }

    public void activityEnded(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(handle.toString() + " ended.");
        }
        this.dataSource.removeActivity(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityUnreferenced(ActivityHandle handle) {
        Object activity;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(handle.toString() + " is now unreferenced, ending activity.");
        }
        if ((activity = this.getActivity(handle)) instanceof RLSServiceActivityImpl) {
            Object object = activity;
            synchronized (object) {
                ((RLSServiceActivityImpl)activity).ending();
                try {
                    this.sleeEndpoint.endActivity(handle);
                }
                catch (Throwable e) {
                    this.tracer.warning("failed to end activity after becoming unreferenced: " + handle, e);
                    this.activityEnded(handle);
                }
            }
        }
        try {
            this.sleeEndpoint.endActivity(handle);
        }
        catch (Throwable e) {
            this.tracer.warning("failed to end activity after becoming unreferenced: " + handle, e);
            this.activityEnded(handle);
        }
    }

    public void administrativeRemove(ActivityHandle handle) {
        this.activityEnded(handle);
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
    }

    public Object getActivity(ActivityHandle handle) {
        return this.dataSource.getActivity(handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return this.dataSource.getActivityHandle(activity);
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String className) {
        return this;
    }

    public void queryLiveness(ActivityHandle handle) {
        if (this.dataSource.getActivity(handle) == null) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("failed to end idle activity " + handle, (Throwable)e);
            }
        }
    }

    public void raActive() {
        this.dataSource = new RLSServicesCacheDataSource();
        this.executorService = Executors.newSingleThreadExecutor();
        this.raActive = true;
        if (SubscriptionControlManagement.getInstance().getEventListSupportOn() && this.serviceActive) {
            this.initService();
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public void raConfigure(ConfigProperties properties) {
    }

    public void raInactive() {
        this.dataSource = null;
        this.executorService.shutdownNow();
    }

    public void raStopping() {
        this.raActive = false;
        if (this.serviceActive) {
            this.endAllActivities();
        }
    }

    public void raUnconfigure() {
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void serviceActive(ReceivableService serviceInfo) {
        if (serviceInfo.getService().equals((Object)this.serviceID)) {
            this.serviceActive = true;
            if (SubscriptionControlManagement.getInstance().getEventListSupportOn() && this.raActive) {
                this.initService();
            }
        }
    }

    private void initService() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    RLSServicesCacheResourceAdaptor.this.sleeEndpoint.startActivity((ActivityHandle)RLSServicesCacheResourceAdaptor.this.dummyRLSServicesDocActivityHandle, (Object)RLSServicesCacheResourceAdaptor.this.dummyRLSServicesDocActivity);
                    RLSServicesCacheResourceAdaptor.this.dataSource.putIfAbsentRLSServiceActivity(RLSServicesCacheResourceAdaptor.this.dummyRLSServicesDocActivityHandle, RLSServicesCacheResourceAdaptor.this.dummyRLSServicesDocActivity);
                    RLSServicesCacheResourceAdaptor.this.sleeEndpoint.fireEvent((ActivityHandle)RLSServicesCacheResourceAdaptor.this.dummyRLSServicesDocActivityHandle, RLSServicesCacheResourceAdaptor.this.watchRLSServicesEvent, (Object)new WatchRLSServicesEvent(), null, null);
                }
                catch (Throwable e) {
                    RLSServicesCacheResourceAdaptor.this.tracer.severe("failed to signal service to watch global rls services doc in the xdm", e);
                    throw new RuntimeException(e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public void serviceInactive(ReceivableService serviceInfo) {
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        if (serviceInfo.getService().equals((Object)this.serviceID)) {
            this.serviceActive = false;
            if (this.raActive) {
                this.endAllActivities();
            }
        }
    }

    private void endAllActivities() {
        if (SubscriptionControlManagement.getInstance().getEventListSupportOn()) {
            final Set<ActivityHandle> handles = this.dataSource.getAllHandles();
            Runnable runnable = new Runnable(){

                public void run() {
                    for (ActivityHandle handle : handles) {
                        try {
                            RLSServicesCacheResourceAdaptor.this.sleeEndpoint.endActivity(handle);
                        }
                        catch (Throwable e) {
                            RLSServicesCacheResourceAdaptor.this.tracer.severe("failed to end activity", e);
                        }
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.tracer = context.getTracer(this.getClass().getSimpleName());
        this.sleeEndpoint = context.getSleeEndpoint();
        try {
            this.watchRLSServicesEvent = context.getEventLookupFacility().getFireableEventType(WatchRLSServicesEvent.EVENT_TYPE_ID);
            this.watchResourceListsEvent = context.getEventLookupFacility().getFireableEventType(WatchResourceListsEvent.EVENT_TYPE_ID);
            this.rLSServicesRemovedEvent = context.getEventLookupFacility().getFireableEventType(RLSServicesRemovedEvent.EVENT_TYPE_ID);
            this.rLSServicesUpdatedEvent = context.getEventLookupFacility().getFireableEventType(RLSServicesUpdatedEvent.EVENT_TYPE_ID);
            this.rLSServicesAddedEvent = context.getEventLookupFacility().getFireableEventType(RLSServicesAddedEvent.EVENT_TYPE_ID);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retreive the event type for the event fired by this RA, unable to proceed", e);
        }
        this.addressParser = new ListReferenceEndpointAddressParser(context);
    }

    public void unsetResourceAdaptorContext() {
        this.tracer = null;
        this.sleeEndpoint = null;
        this.watchRLSServicesEvent = null;
        this.watchResourceListsEvent = null;
        this.rLSServicesRemovedEvent = null;
        this.rLSServicesUpdatedEvent = null;
        this.addressParser = null;
    }

    public RLSService getRLSService(String serviceURI) {
        return this.dataSource.getRLSService(serviceURI);
    }

    public RLSServiceActivity getRLSServiceActivity(String serviceURI) throws StartActivityException {
        RLSServiceActivityImpl activity;
        RLSServiceActivityHandle handle;
        RLSServiceActivityImpl existentActivity;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("getRLSServiceActivity( uri = " + serviceURI + ")");
        }
        if ((existentActivity = this.dataSource.putIfAbsentRLSServiceActivity(handle = new RLSServiceActivityHandle(serviceURI), activity = new RLSServiceActivityImpl(serviceURI, this))) == null) {
            this.sleeEndpoint.startActivitySuspended((ActivityHandle)handle, (Object)activity, ACTIVITY_FLAGS);
        } else {
            activity = existentActivity;
        }
        return activity;
    }

    public void rlsServicesUpdated(final DocumentSelector documentSelector, final String document) {
        Runnable r = new Runnable(){

            public void run() {
                block13: {
                    block12: {
                        if (RLSServicesCacheResourceAdaptor.this.tracer.isFineEnabled()) {
                            RLSServicesCacheResourceAdaptor.this.tracer.fine("rlsServicesDocUpdated( ds = " + documentSelector + ")");
                        }
                        if (document != null) break block12;
                        RLSServiceImpl rlsService = null;
                        for (String existentRLSServiceURI : RLSServicesCacheResourceAdaptor.this.dataSource.removeRlsServicesDocs(documentSelector)) {
                            rlsService = RLSServicesCacheResourceAdaptor.this.dataSource.removeRLSService(existentRLSServiceURI);
                            if (rlsService != null) {
                                rlsService.setServiceType(null);
                            }
                            if (!RLSServicesCacheResourceAdaptor.this.tracer.isInfoEnabled()) continue;
                            RLSServicesCacheResourceAdaptor.this.tracer.info("Removed RLS Service " + existentRLSServiceURI + " from cache.");
                        }
                        break block13;
                    }
                    RlsServices rlsServices = null;
                    try {
                        rlsServices = (RlsServices)jaxbContext.createUnmarshaller().unmarshal((Reader)new StringReader(document));
                    }
                    catch (JAXBException e) {
                        RLSServicesCacheResourceAdaptor.this.tracer.severe("unmarshalling of global rls services failed", (Throwable)e);
                        return;
                    }
                    Set<String> removedRlsServices = RLSServicesCacheResourceAdaptor.this.dataSource.removeRlsServicesDocs(documentSelector);
                    HashSet<String> updatedRlsServices = new HashSet<String>();
                    RLSServiceImpl rlsService = null;
                    RLSServiceImpl anotherRlsService = null;
                    for (ServiceType serviceType : rlsServices.getService()) {
                        if (removedRlsServices != null) {
                            removedRlsServices.remove(serviceType.getUri());
                        }
                        updatedRlsServices.add(serviceType.getUri());
                        rlsService = RLSServicesCacheResourceAdaptor.this.dataSource.getRLSService(serviceType.getUri());
                        if (rlsService == null) {
                            LinkedList<ElementSelectorStepByAttr> steps = new LinkedList<ElementSelectorStepByAttr>(RLSServicesCacheResourceAdaptor.this.rlsServicesBaseElementSelectorSteps);
                            steps.addLast(new ElementSelectorStepByAttr("service", "uri", serviceType.getUri()));
                            ListReferenceEndpointAddress address = new ListReferenceEndpointAddress(RLSServicesCacheResourceAdaptor.this.globalRLSServicesDocumentSelector, new ElementSelector(steps));
                            anotherRlsService = new RLSServiceImpl(serviceType.getUri(), address, RLSServicesCacheResourceAdaptor.this);
                            rlsService = RLSServicesCacheResourceAdaptor.this.dataSource.putRLSServiceIfAbsent(serviceType.getUri(), anotherRlsService);
                            if (rlsService == null) {
                                rlsService = anotherRlsService;
                                if (RLSServicesCacheResourceAdaptor.this.tracer.isInfoEnabled()) {
                                    RLSServicesCacheResourceAdaptor.this.tracer.info("Added RLS Service " + serviceType.getUri() + " to cache.");
                                }
                            }
                        }
                        rlsService.setServiceType(serviceType);
                    }
                    RLSServicesCacheResourceAdaptor.this.dataSource.putRlsServicesDocs(documentSelector, updatedRlsServices);
                    if (removedRlsServices == null) break block13;
                    for (String removedRLSServiceURI : removedRlsServices) {
                        rlsService = RLSServicesCacheResourceAdaptor.this.dataSource.removeRLSService(removedRLSServiceURI);
                        if (rlsService != null) {
                            rlsService.setServiceType(null);
                        }
                        if (!RLSServicesCacheResourceAdaptor.this.tracer.isInfoEnabled()) continue;
                        RLSServicesCacheResourceAdaptor.this.tracer.info("Removed RLS Service " + removedRLSServiceURI + " from cache.");
                    }
                }
            }
        };
        this.executorService.submit(r);
    }

    public void resourceListsUpdated(final DocumentSelector documentSelector, final String document) {
        Runnable r = new Runnable(){

            public void run() {
                ReferencedResourceLists referencedResourceLists;
                if (RLSServicesCacheResourceAdaptor.this.tracer.isFineEnabled()) {
                    RLSServicesCacheResourceAdaptor.this.tracer.fine("resourceListsUpdated, document selector is " + documentSelector);
                }
                ResourceLists resourceLists = null;
                if (document != null) {
                    try {
                        resourceLists = (ResourceLists)jaxbContext.createUnmarshaller().unmarshal((Reader)new StringReader(document));
                    }
                    catch (JAXBException e) {
                        RLSServicesCacheResourceAdaptor.this.tracer.severe("unmarshalling of resource lists failed", (Throwable)e);
                        return;
                    }
                }
                if ((referencedResourceLists = RLSServicesCacheResourceAdaptor.this.dataSource.getResourceList(documentSelector)) != null) {
                    referencedResourceLists.setResourceLists(resourceLists);
                }
            }
        };
        this.executorService.submit(r);
    }

    public void removeReference(ListReferenceEndpointAddress fromAddress, ListReferenceEndpointAddress toAddress) {
        DocumentSelector documentSelector;
        ReferencedResourceLists lists;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("removeReference from = " + fromAddress + ", to = " + toAddress);
        }
        if ((lists = this.dataSource.getResourceList(documentSelector = toAddress.getDocumentSelector())) != null) {
            lists.removeFromReference(fromAddress, toAddress);
            if (!lists.hasFromReferences()) {
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Removed Resource List " + documentSelector + " from cache, no references.");
                }
                this.dataSource.removeResourceList(documentSelector);
                ResourceListActivityHandle handle = new ResourceListActivityHandle(documentSelector);
                try {
                    this.sleeEndpoint.endActivity((ActivityHandle)handle);
                }
                catch (Throwable e) {
                    this.tracer.severe("failed to end resource list activity " + documentSelector, e);
                    this.dataSource.removeResourceListActivity(handle);
                }
            }
        }
    }

    public ListReferenceTo addReference(ListReferenceFrom from, ListReferenceEndpointAddress toAddress) {
        ReferencedResourceLists newLists;
        DocumentSelector documentSelector;
        ReferencedResourceLists lists;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("addReference from = " + from.getAddress() + ", to = " + toAddress);
        }
        if ((lists = this.dataSource.getResourceList(documentSelector = toAddress.getDocumentSelector())) == null && (lists = this.dataSource.putResourceListIfAbsent(documentSelector, newLists = new ReferencedResourceLists(documentSelector, this))) == null) {
            lists = newLists;
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Added Resource List " + documentSelector + " to cache.");
            }
            ResourceListActivityHandle handle = new ResourceListActivityHandle(documentSelector);
            try {
                this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)new ResourceListActivityImpl(documentSelector), ACTIVITY_FLAGS);
                this.sleeEndpoint.fireEvent((ActivityHandle)handle, this.watchResourceListsEvent, (Object)new WatchResourceListsEvent(documentSelector), null, null);
            }
            catch (Throwable e) {
                this.tracer.severe("failed to start resource list activity " + documentSelector, e);
                this.dataSource.removeResourceListActivity(handle);
                this.dataSource.removeResourceList(documentSelector);
                return null;
            }
        }
        return lists.addFromReference(from, toAddress);
    }

    public void fireRLSServicesAddedEvent(String uri, RLSServicesAddedEvent event) {
        RLSServiceActivityHandle handle = new RLSServiceActivityHandle(uri);
        try {
            RLSServiceActivityImpl activity = this.dataSource.getRLSServiceActivity(handle);
            if (activity == null && this.dataSource.putIfAbsentRLSServiceActivity(handle, activity = new RLSServiceActivityImpl(uri, this)) == null) {
                this.sleeEndpoint.startActivity((ActivityHandle)handle, (Object)activity, ACTIVITY_FLAGS);
            }
            this.sleeEndpoint.fireEvent((ActivityHandle)handle, this.rLSServicesAddedEvent, (Object)event, null, null);
        }
        catch (Throwable e) {
            this.tracer.severe("failed to fire rls services added event", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRLSServicesRemovedEvent(String uri, RLSServicesRemovedEvent event) {
        RLSServiceActivityHandle handle = new RLSServiceActivityHandle(uri);
        RLSServiceActivityImpl activity = this.dataSource.getRLSServiceActivity(handle);
        if (activity != null) {
            RLSServiceActivityImpl rLSServiceActivityImpl = activity;
            synchronized (rLSServiceActivityImpl) {
                if (!activity.isEnding()) {
                    try {
                        this.sleeEndpoint.fireEvent((ActivityHandle)handle, this.rLSServicesRemovedEvent, (Object)event, null, null);
                    }
                    catch (Throwable e) {
                        this.tracer.severe("failed to fire event", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRLSServicesUpdatedEvent(String uri, RLSServicesUpdatedEvent event) {
        RLSServiceActivityHandle handle;
        RLSServiceActivityImpl activity;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Updated RLS Service " + uri + ". New entries: " + event.getNewEntries() + ". Removed entries: " + event.getRemovedEntries());
        }
        if ((activity = this.dataSource.getRLSServiceActivity(handle = new RLSServiceActivityHandle(uri))) != null) {
            RLSServiceActivityImpl rLSServiceActivityImpl = activity;
            synchronized (rLSServiceActivityImpl) {
                if (!activity.isEnding()) {
                    try {
                        this.sleeEndpoint.fireEvent((ActivityHandle)handle, this.rLSServicesUpdatedEvent, (Object)event, null, null);
                    }
                    catch (Throwable e) {
                        this.tracer.severe("failed to fire event", e);
                    }
                }
            }
        }
    }

    public ListReferenceEndpointAddressParser getAddressParser() {
        return this.addressParser;
    }
}

